/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLFieldTranslator;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;

public class ComptabiliteWorkflowPreferencePanel
extends DefaultPreferencePanel {
    public static final String LETTRAGE_PROPO_KM = "LettragePropoKM";
    private static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private SQLRowValues rowPrefCompteVals = new SQLRowValues(tablePrefCompte);
    private JCheckBox checkLettrageKmPropo = new JCheckBox("Afficher une fen\u00eatre de lettrage lors d'une saisie au kilom\u00e8tre.");
    private JCheckBox checkLettrageAuto = new JCheckBox("Activer le lettrage automatique.");
    private JCheckBox checkHideCompteFacture = new JCheckBox("Ne pas afficher les comptes dans les factures.");
    private JCheckBox checkHideCompteClient = new JCheckBox("Ne pas afficher les comptes dans les clients.");
    private JCheckBox checkHideAnalytique = new JCheckBox("Ne pas afficher l'analytique dans les saisies au kilom\u00e8tre.");

    public ComptabiliteWorkflowPreferencePanel() {
        SQLRow rowPrefCompte = tablePrefCompte.getRow(2);
        this.rowPrefCompteVals.loadAbsolutelyAll(rowPrefCompte);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        this.add((Component)this.checkLettrageAuto, c);
        ++c.gridy;
        this.add((Component)this.checkLettrageKmPropo, c);
        ++c.gridy;
        this.add((Component)this.checkHideCompteClient, c);
        ++c.gridy;
        this.add((Component)this.checkHideCompteFacture, c);
        ++c.gridy;
        this.add((Component)this.checkHideAnalytique, c);
        ++c.gridy;
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)new JPanel(), c);
        this.setValues();
    }

    @Override
    public void storeValues() {
        this.rowPrefCompteVals.put("AUTO_LETTRAGE", this.checkLettrageAuto.isSelected());
        DefaultNXProps.getInstance().setProperty(LETTRAGE_PROPO_KM, String.valueOf(this.checkLettrageKmPropo.isSelected()));
        DefaultNXProps.getInstance().setProperty("HideCompteClient", String.valueOf(this.checkHideCompteClient.isSelected()));
        DefaultNXProps.getInstance().setProperty("HideCompteFacture", String.valueOf(this.checkHideCompteFacture.isSelected()));
        DefaultNXProps.getInstance().setProperty("HideAnalytique", String.valueOf(this.checkHideAnalytique.isSelected()));
        DefaultNXProps.getInstance().store();
        try {
            Object[] pb = this.rowPrefCompteVals.getInvalid();
            if (pb != null) {
                SQLFieldTranslator trans = Configuration.getInstance().getTranslator();
                JOptionPane.showMessageDialog(SwingUtilities.getRoot(this), "Impossible de valider les modifications! Le champ <" + trans.getLabelFor(this.rowPrefCompteVals.getTable().getField(pb[0].toString())) + "> pointe sur un compte invalide!(" + pb[1] + ")");
            } else {
                this.rowPrefCompteVals.update();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void restoreToDefaults() {
        this.checkLettrageAuto.setSelected(false);
        this.checkLettrageKmPropo.setSelected(false);
    }

    @Override
    public String getTitleName() {
        return "Comptabilit\u00e9";
    }

    private void setValues() {
        try {
            this.checkLettrageAuto.setSelected(this.rowPrefCompteVals.getBoolean("AUTO_LETTRAGE"));
            this.checkLettrageKmPropo.setSelected(Boolean.valueOf(DefaultNXProps.getInstance().getProperty(LETTRAGE_PROPO_KM)));
            this.checkHideCompteClient.setSelected(Boolean.valueOf(DefaultNXProps.getInstance().getProperty("HideCompteClient")));
            this.checkHideCompteFacture.setSelected(Boolean.valueOf(DefaultNXProps.getInstance().getProperty("HideCompteFacture")));
            this.checkHideAnalytique.setSelected(Boolean.valueOf(DefaultNXProps.getInstance().getProperty("HideAnalytique")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

