/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class DeviseTableCellRenderer
extends DefaultTableCellRenderer {
    private final DecimalFormat decimalFormat;
    private final DecimalFormat decimalFormat2;
    private BigDecimal oneCents = new BigDecimal(0.01f);
    private boolean hideZeroValue = false;

    public DeviseTableCellRenderer() {
        this(new DecimalFormat("##,##0.00#"), new DecimalFormat("##,##0.00#######"));
    }

    public DeviseTableCellRenderer(DecimalFormat decimalFormat, DecimalFormat decimalFormatLessOne) {
        this.decimalFormat = decimalFormat;
        this.decimalFormat2 = decimalFormatLessOne;
        DecimalFormatSymbols symbol = DecimalFormatSymbols.getInstance();
        symbol.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(symbol);
        this.decimalFormat2.setDecimalFormatSymbols(symbol);
    }

    public void setHideZeroValue(boolean hideZeroValue) {
        this.hideZeroValue = hideZeroValue;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(this, table, isSelected);
        this.setHorizontalAlignment(4);
        if (table.getColumnClass(column) != BigDecimal.class) {
            throw new IllegalStateException("Value is not a BigDecimal :" + table.getColumnClass(column));
        }
        if (value != null) {
            BigDecimal amount = (BigDecimal)value;
            if (this.hideZeroValue && amount.signum() == 0) {
                this.setText("");
            } else if (amount.compareTo(this.oneCents) < 0) {
                this.setText(this.decimalFormat2.format(value));
            } else {
                this.setText(this.decimalFormat.format(value));
            }
        } else {
            this.setText("");
        }
        return this;
    }
}

