/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class DeviseField
extends JTextField
implements ValueWrapper<Long>,
Documented,
RowItemViewComponent {
    private SQLField field;
    private final PropertyChangeSupport supp;
    private boolean gained;
    private boolean mousePressed;
    private String initialText;
    private boolean authorizedNegative = false;

    public DeviseField() {
        this(false);
    }

    public DeviseField(boolean bold) {
        this(15, bold);
    }

    public DeviseField(int columns) {
        this(columns, false);
    }

    private DeviseField(int columns, boolean bold) {
        super(columns);
        if (bold) {
            this.setFont(this.getFont().deriveFont(1));
        }
        this.supp = new PropertyChangeSupport(this);
        this.gained = false;
        this.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                DeviseField.this.textModified();
            }
        });
        this.init();
    }

    protected void textModified() {
        this.supp.firePropertyChange("value", null, this.getValue());
    }

    @Override
    public void init(SQLRowItemView v) {
        this.field = v.getField();
    }

    private void init() {
        DeviseField.addFilteringKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DeviseField.this.gained = true;
                DeviseField.this.initialText = DeviseField.this.getText();
                if (!DeviseField.this.mousePressed) {
                    DeviseField.this.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DeviseField.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DeviseField.this.gained && DeviseField.this.getSelectedText() == null) {
                    DeviseField.this.selectAll();
                }
                DeviseField.this.gained = false;
                DeviseField.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    DeviseField.this.setValue(DeviseField.this.initialText);
                    DeviseField.this.selectAll();
                }
            }
        });
    }

    public boolean isAuthorizedNegative() {
        return this.authorizedNegative;
    }

    public void setAuthorizedNegative(boolean authorizedNegative) {
        this.authorizedNegative = authorizedNegative;
    }

    public static void addFilteringKeyListener(final DeviseField textField) {
        textField.addKeyListener(new KeyAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = textField.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (textField.getSelectedText() != null) return;
                    if (textField.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (textField.getText().substring(pointPosition).length() <= 2) {
                        return;
                    }
                }
                if (keychar == '.' && textField.getText().indexOf(46) < 0) {
                    return;
                }
                if (textField.isAuthorizedNegative() && keychar == '-' && textField.getText().indexOf(45) < 0 && textField.getCaretPosition() == 0) {
                    return;
                }
                keyEvent.consume();
            }
        });
    }

    @Override
    public final void resetValue() {
        this.setValue((Long)null);
    }

    @Override
    public void setValue(Long val) {
        this.setValue(val == null ? "" : GestionDevise.currencyToString(val));
    }

    @Override
    private final void setValue(String val) {
        if (!this.getText().equals(val)) {
            this.setText(val);
        }
    }

    public void setBold() {
        this.setFont(this.getFont().deriveFont(1));
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " authorizedNegative: " + this.isAuthorizedNegative();
    }

    @Override
    public Long getValue() {
        if (this.getText().trim().length() == 0) {
            return null;
        }
        return GestionDevise.parseLongCurrency(this.getText());
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public SQLField getField() {
        return this.field;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public String getDocId() {
        return "DEVISE";
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }
}

