/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg.color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.experimental.alg.ApproximationAlgorithm;
import org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

public class GreedyColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ApproximationAlgorithm<Integer, V> {
    public static final int BEST_ORDER = 0;
    public static final int NATURAL_ORDER = 1;
    public static final int SMALLEST_DEGREE_LAST_ORDER = 2;
    public static final int LARGEST_SATURATION_FIRST_ORDER = 3;
    private int _order = 0;

    public GreedyColoring(Graph<V, E> g) {
        this(g, 0);
    }

    public GreedyColoring(Graph<V, E> g, int method) {
        super(g);
        this._order = method;
    }

    int color(int[] order) {
        int[] color = new int[this._neighbors.length];
        int maxColor = 1;
        BitSet usedColors = new BitSet(this._neighbors.length);
        int i = 0;
        while (i < this._neighbors.length) {
            int v = order == null ? i : order[i];
            usedColors.clear();
            int j = 0;
            while (j < this._neighbors[v].length) {
                int nb = this._neighbors[v][j];
                if (color[nb] > 0) {
                    usedColors.set(color[nb]);
                }
                ++j;
            }
            color[v] = 1;
            while (usedColors.get(color[v])) {
                int n = v;
                color[n] = color[n] + 1;
            }
            if (color[v] > maxColor) {
                maxColor = color[v];
            }
            ++i;
        }
        return maxColor;
    }

    /*
     * Unable to fully structure code
     */
    int[] smallestDegreeLastOrder() {
        order = new int[this._neighbors.length];
        degree = new int[this._neighbors.length];
        buckets = new List[this._neighbors.length];
        index = this._neighbors.length - 1;
        i = 0;
        while (i < this._neighbors.length) {
            buckets[i] = new ArrayList<E>();
            degree[i] = this._neighbors[i].length;
            ++i;
        }
        i = 0;
        while (i < this._neighbors.length) {
            buckets[degree[i]].add(i);
            ++i;
        }
        i = 0;
        ** GOTO lbl42
        {
            s = buckets[i].size() - 1;
            vertex = (Integer)buckets[i].get(s);
            buckets[i].remove(s);
            degree[vertex] = -1;
            order[index--] = vertex;
            j = 0;
            while (j < this._neighbors[vertex].length) {
                nb = this._neighbors[vertex][j];
                if (degree[nb] >= 0) {
                    buckets[degree[nb]].remove(new Integer(nb));
                    v0 = nb;
                    degree[v0] = degree[v0] - 1;
                    buckets[degree[nb]].add(nb);
                    if (degree[nb] < i) {
                        i = degree[nb];
                    }
                }
                ++j;
            }
            do {
                if (buckets[i].size() > 0) continue block2;
                ++i;
lbl42:
                // 2 sources

            } while (i < this._neighbors.length);
        }
        return order;
    }

    /*
     * Unable to fully structure code
     */
    int[] largestSaturationFirstOrder() {
        order = new int[this._neighbors.length];
        satur = new int[this._neighbors.length];
        buckets = new int[this._neighbors.length];
        cumBucketSize = new int[this._neighbors.length];
        bucketIndex = new int[this._neighbors.length];
        index = 0;
        maxSat = 0;
        i = 0;
        while (i < this._neighbors.length) {
            buckets[i] = i;
            bucketIndex[i] = i;
            ++i;
        }
        cumBucketSize[0] = this._neighbors.length;
        ** GOTO lbl44
        {
            cumBucketSize[maxSat--] = 0;
            do {
                if (maxSat > 0 && cumBucketSize[maxSat] == cumBucketSize[maxSat - 1]) continue block1;
                v = buckets[cumBucketSize[maxSat] - 1];
                v0 = maxSat;
                cumBucketSize[v0] = cumBucketSize[v0] - 1;
                satur[v] = -1;
                order[index++] = v;
                j = 0;
                while (j < this._neighbors[v].length) {
                    nb = this._neighbors[v][j];
                    bi = bucketIndex[nb];
                    if (satur[nb] >= 0) {
                        if (bi != cumBucketSize[satur[nb]] - 1) {
                            buckets[bi] = buckets[cumBucketSize[satur[nb]] - 1];
                            buckets[cumBucketSize[satur[nb]] - 1] = nb;
                            bucketIndex[nb] = cumBucketSize[satur[nb]] - 1;
                            bucketIndex[buckets[bi]] = bi;
                        }
                        v1 = satur[nb];
                        cumBucketSize[v1] = cumBucketSize[v1] - 1;
                        v2 = nb;
                        satur[v2] = satur[v2] + 1;
                        if (cumBucketSize[satur[nb]] == 0) {
                            cumBucketSize[satur[nb]] = cumBucketSize[satur[nb] - 1] + 1;
                        }
                        if (satur[nb] > maxSat) {
                            maxSat = satur[nb];
                        }
                    }
                    ++j;
                }
lbl44:
                // 2 sources

            } while (index < this._neighbors.length);
        }
        Collections.reverse(Arrays.asList(new int[][]{buckets}));
        return buckets;
    }

    @Override
    public Integer getLowerBound(Map<V, Object> optionalData) {
        return 0;
    }

    @Override
    public Integer getUpperBound(Map<V, Object> optionalData) {
        switch (this._order) {
            case 0: {
                return Math.min(Math.min(this.color(null), this.color(this.smallestDegreeLastOrder())), this.color(this.largestSaturationFirstOrder()));
            }
            case 1: {
                return this.color(null);
            }
            case 2: {
                return this.color(this.smallestDegreeLastOrder());
            }
            case 3: {
                return this.color(this.largestSaturationFirstOrder());
            }
        }
        return this._neighbors.length;
    }

    @Override
    public boolean isExact() {
        return false;
    }
}

