/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeType;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;

public abstract class MimeDetector {
    public final String getName() {
        return this.getClass().getName();
    }

    public final Collection<MimeType> getMimeTypes(String fileName) throws UnsupportedOperationException {
        return this.getMimeTypesFileName(fileName);
    }

    public final Collection<MimeType> getMimeTypes(File file) throws UnsupportedOperationException {
        return this.getMimeTypesFile(file);
    }

    public final Collection<MimeType> getMimeTypes(URL url) throws UnsupportedOperationException {
        return this.getMimeTypesURL(url);
    }

    public final Collection<MimeType> getMimeTypes(byte[] data) throws UnsupportedOperationException {
        return this.getMimeTypesByteArray(data);
    }

    public final Collection<MimeType> getMimeTypes(InputStream in) throws UnsupportedOperationException {
        if (!in.markSupported()) {
            throw new UnsupportedOperationException("The InputStream must support the mark() and reset() methods.");
        }
        return this.getMimeTypesInputStream(in);
    }

    public void init() {
    }

    public void delete() {
    }

    public abstract String getDescription();

    protected abstract Collection<MimeType> getMimeTypesFileName(String var1) throws UnsupportedOperationException;

    protected abstract Collection<MimeType> getMimeTypesFile(File var1) throws UnsupportedOperationException;

    protected abstract Collection<MimeType> getMimeTypesURL(URL var1) throws UnsupportedOperationException;

    protected abstract Collection<MimeType> getMimeTypesInputStream(InputStream var1) throws UnsupportedOperationException;

    protected abstract Collection<MimeType> getMimeTypesByteArray(byte[] var1) throws UnsupportedOperationException;

    protected static InputStream closeStream(InputStream in) {
        if (in == null) {
            return null;
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

