/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.detector.InvalidMagicMimeEntryException;
import eu.medsea.mimeutil.detector.MagicMimeEntryOperation;
import eu.medsea.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

class MagicMimeEntry {
    public static final int STRING_TYPE = 1;
    public static final int BELONG_TYPE = 2;
    public static final int SHORT_TYPE = 3;
    public static final int LELONG_TYPE = 4;
    public static final int BESHORT_TYPE = 5;
    public static final int LESHORT_TYPE = 6;
    public static final int BYTE_TYPE = 7;
    public static final int UNKNOWN_TYPE = 20;
    private ArrayList subEntries = new ArrayList();
    private int checkBytesFrom;
    private int type;
    private String typeStr;
    private String content;
    private long contentNumber;
    private MimeType mimeType;
    private String mimeEnc;
    private MagicMimeEntry parent;
    private MagicMimeEntryOperation operation = MagicMimeEntryOperation.EQUALS;
    boolean isBetween;

    public MagicMimeEntry(ArrayList entries) throws InvalidMagicMimeEntryException {
        this(0, null, entries);
    }

    private MagicMimeEntry(int level, MagicMimeEntry parent, ArrayList entries) throws InvalidMagicMimeEntryException {
        if (entries == null || entries.size() == 0) {
            return;
        }
        this.parent = parent;
        if (parent != null) {
            parent.subEntries.add(this);
        }
        try {
            this.addEntry((String)entries.get(0));
        }
        catch (Exception e) {
            throw new InvalidMagicMimeEntryException(entries, (Throwable)e);
        }
        entries.remove(0);
        while (entries.size() > 0) {
            int thisLevel = this.howManyGreaterThans((String)entries.get(0));
            if (thisLevel <= level) break;
            new MagicMimeEntry(thisLevel, this, entries);
        }
    }

    public String toString() {
        return "MimeMagicType: " + this.checkBytesFrom + ", " + this.type + ", " + this.content + ", " + this.mimeType + ", " + this.mimeEnc;
    }

    public void traverseAndPrint(String tabs) {
        System.out.println(String.valueOf(tabs) + this.toString());
        int len = this.subEntries.size();
        int i = 0;
        while (i < len) {
            MagicMimeEntry me = (MagicMimeEntry)this.subEntries.get(i);
            me.traverseAndPrint(String.valueOf(tabs) + "\t");
            ++i;
        }
    }

    private int howManyGreaterThans(String aLine) {
        if (aLine == null) {
            return -1;
        }
        int i = 0;
        int len = aLine.length();
        while (i < len) {
            if (aLine.charAt(i) != '>') break;
            ++i;
        }
        return i;
    }

    void addEntry(String aLine) throws InvalidMagicMimeEntryException {
        String trimmed = aLine.replaceAll("[\\\\][ ]", "<##>").replaceAll("^>*", "").replaceAll("\\s+", "\t").replaceAll("[\t]{2,}", "\t").replaceAll("<##>", "\\\\ ");
        String[] tokens = trimmed.split("\t");
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < tokens.length) {
            if (!"".equals(tokens[i])) {
                v.add(tokens[i]);
            }
            ++i;
        }
        tokens = new String[v.size()];
        if ((tokens = v.toArray(tokens)).length > 0) {
            String tok = tokens[0].trim();
            try {
                this.checkBytesFrom = tok.startsWith("0x") ? Integer.parseInt(tok.substring(2), 16) : Integer.parseInt(tok);
            }
            catch (NumberFormatException e) {
                throw new InvalidMagicMimeEntryException(Collections.singletonList(this), (Throwable)e);
            }
        }
        if (tokens.length > 1) {
            this.typeStr = tokens[1].trim();
            this.type = this.getType(this.typeStr);
        }
        if (tokens.length > 2) {
            this.content = this.ltrim(tokens[2]);
            switch (this.type) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.operation = MagicMimeEntryOperation.getOperationForNumberField(this.content);
                    break;
                }
                default: {
                    this.operation = MagicMimeEntryOperation.getOperationForStringField(this.content);
                }
            }
            if (this.content.length() > 0 && this.content.charAt(0) == this.operation.getOperationID()) {
                this.content = this.content.substring(1);
            }
            this.content = MagicMimeEntry.stringWithEscapeSubstitutions(this.content);
        } else {
            this.content = "";
        }
        if (tokens.length > 3) {
            this.mimeType = new MimeType(tokens[3].trim());
        }
        if (tokens.length > 4) {
            this.mimeEnc = tokens[4].trim();
        }
        this.initContentNumber();
    }

    private void initContentNumber() {
        this.contentNumber = 0L;
        if (this.content.length() == 0) {
            return;
        }
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.contentNumber = this.content.startsWith("0x") ? Long.parseLong(this.content.substring(2).trim(), 16) : (this.content.startsWith("0") ? Long.parseLong(this.content.trim(), 8) : Long.parseLong(this.content.trim()));
            }
        }
    }

    private String ltrim(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) != ' ') {
                return s.substring(i);
            }
            ++i;
        }
        return s;
    }

    private int getType(String tok) {
        if (tok.startsWith("string")) {
            return 1;
        }
        if (tok.startsWith("belong")) {
            return 2;
        }
        if (tok.equals("short")) {
            return 3;
        }
        if (tok.startsWith("lelong")) {
            return 4;
        }
        if (tok.startsWith("beshort")) {
            return 5;
        }
        if (tok.startsWith("leshort")) {
            return 6;
        }
        if (tok.equals("byte")) {
            return 7;
        }
        return 20;
    }

    public int getCheckBytesFrom() {
        return this.checkBytesFrom;
    }

    public int getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    MagicMimeEntry getMatch(InputStream in) throws IOException {
        int bytesToRead = this.getInputStreamMarkLength();
        in.mark(bytesToRead);
        try {
            byte[] content = new byte[bytesToRead];
            int offset = 0;
            int restBytesToRead = bytesToRead;
            while (restBytesToRead > 0) {
                int bytesRead = in.read(content, offset, restBytesToRead);
                if (bytesRead < 0) break;
                offset += bytesRead;
                restBytesToRead -= bytesRead;
            }
            MagicMimeEntry magicMimeEntry = this.getMatch(content);
            return magicMimeEntry;
        }
        finally {
            in.reset();
        }
    }

    MagicMimeEntry getMatch(byte[] content) throws IOException {
        ByteBuffer buf = this.readBuffer(content);
        if (buf == null) {
            return null;
        }
        buf.position(0);
        boolean matches = this.match(buf);
        if (matches) {
            int subLen = this.subEntries.size();
            MimeType mimeType = this.getMimeType();
            if (subLen > 0) {
                int k = 0;
                while (k < subLen) {
                    MagicMimeEntry me = (MagicMimeEntry)this.subEntries.get(k);
                    MagicMimeEntry matchingEntry = me.getMatch(content);
                    if (matchingEntry != null) {
                        return matchingEntry;
                    }
                    ++k;
                }
                if (mimeType != null) {
                    return this;
                }
            } else if (mimeType != null) {
                return this;
            }
        }
        return null;
    }

    MagicMimeEntry getMatch(RandomAccessFile raf) throws IOException {
        ByteBuffer buf = this.readBuffer(raf);
        if (buf == null) {
            return null;
        }
        boolean matches = this.match(buf);
        if (matches) {
            MimeType mimeType = this.getMimeType();
            if (this.subEntries.size() > 0) {
                int i = 0;
                while (i < this.subEntries.size()) {
                    MagicMimeEntry me = (MagicMimeEntry)this.subEntries.get(i);
                    MagicMimeEntry matchingEntry = me.getMatch(raf);
                    if (matchingEntry != null) {
                        return matchingEntry;
                    }
                    ++i;
                }
                if (mimeType != null) {
                    return this;
                }
            } else if (mimeType != null) {
                return this;
            }
        }
        return null;
    }

    private ByteBuffer readBuffer(byte[] content) throws IOException {
        int startPos = this.getCheckBytesFrom();
        if (content == null || startPos > content.length) {
            return null;
        }
        ByteBuffer buf = null;
        try {
            switch (this.getType()) {
                case 1: {
                    int len = 0;
                    int index = this.typeStr.indexOf(">");
                    if (index != -1) {
                        len = Integer.parseInt(this.typeStr.substring(index + 1, this.typeStr.length() - 1));
                        this.isBetween = true;
                    } else {
                        len = this.getContent().length();
                    }
                    buf = ByteBuffer.allocate(len);
                    buf.put(content, startPos, len);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    buf = ByteBuffer.allocate(2);
                    buf.put(content, startPos, 2);
                    break;
                }
                case 2: 
                case 4: {
                    buf = ByteBuffer.allocate(4);
                    buf.put(content, startPos, 4);
                    break;
                }
                case 7: {
                    buf = ByteBuffer.allocate(1);
                    buf.put(content, startPos, 1);
                    break;
                }
                default: {
                    buf = null;
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
        return buf;
    }

    private ByteBuffer readBuffer(RandomAccessFile raf) throws IOException {
        ByteBuffer buf;
        int startPos = this.getCheckBytesFrom();
        if ((long)startPos > raf.length()) {
            return null;
        }
        raf.seek(startPos);
        switch (this.getType()) {
            case 1: {
                int len = 0;
                int index = this.typeStr.indexOf(">");
                if (index != -1) {
                    len = Integer.parseInt(this.typeStr.substring(index + 1, this.typeStr.length() - 1));
                    this.isBetween = true;
                } else {
                    len = this.getContent().length();
                }
                buf = ByteBuffer.allocate(len);
                raf.read(buf.array(), 0, len);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                buf = ByteBuffer.allocate(2);
                raf.read(buf.array(), 0, 2);
                break;
            }
            case 2: 
            case 4: {
                buf = ByteBuffer.allocate(4);
                raf.read(buf.array(), 0, 4);
                break;
            }
            case 7: {
                buf = ByteBuffer.allocate(1);
                raf.read(buf.array(), 0, 1);
                break;
            }
            default: {
                buf = null;
            }
        }
        return buf;
    }

    private int getInputStreamMarkLength() {
        int len = this._getInputStreamMarkLength();
        for (MagicMimeEntry subEntry : this.subEntries) {
            int subLen = subEntry.getInputStreamMarkLength();
            if (len >= subLen) continue;
            len = subLen;
        }
        return len;
    }

    private int _getInputStreamMarkLength() {
        switch (this.getType()) {
            case 1: {
                int len = 0;
                int index = this.typeStr.indexOf(">");
                if (index != -1) {
                    len = Integer.parseInt(this.typeStr.substring(index + 1, this.typeStr.length() - 1));
                    this.isBetween = true;
                } else if (this.getContent() != null) {
                    len = this.getContent().length();
                }
                return this.getCheckBytesFrom() + len + 1;
            }
            case 3: 
            case 5: 
            case 6: {
                return this.getCheckBytesFrom() + 2;
            }
            case 2: 
            case 4: {
                return this.getCheckBytesFrom() + 4;
            }
            case 7: {
                return this.getCheckBytesFrom() + 1;
            }
        }
        return 0;
    }

    private boolean match(ByteBuffer buf) throws IOException {
        boolean matches = true;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        switch (this.getType()) {
            case 1: {
                matches = this.matchString(buf);
                break;
            }
            case 3: {
                matches = this.matchShort(buf, byteOrder);
                break;
            }
            case 5: 
            case 6: {
                if (this.getType() == 6) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                matches = this.matchShort(buf, byteOrder);
                break;
            }
            case 2: 
            case 4: {
                if (this.getType() == 4) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                matches = this.matchLong(buf, byteOrder);
                break;
            }
            case 7: {
                matches = this.matchByte(buf);
                break;
            }
            default: {
                matches = false;
            }
        }
        return matches;
    }

    private boolean matchString(ByteBuffer bbuf) throws IOException {
        if (this.isBetween) {
            String buffer = new String(bbuf.array());
            return StringUtil.contains(buffer, this.getContent());
        }
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            int read = this.getContent().length();
            int j = 0;
            while (j < read) {
                if ((bbuf.get(j) & 0xFF) != this.getContent().charAt(j)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            int read = this.getContent().length();
            int j = 0;
            while (j < read) {
                if ((bbuf.get(j) & 0xFF) != this.getContent().charAt(j)) {
                    return true;
                }
                ++j;
            }
            return false;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            String buffer = new String(bbuf.array());
            return buffer.compareTo(this.getContent()) > 0;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            String buffer = new String(bbuf.array());
            return buffer.compareTo(this.getContent()) < 0;
        }
        return false;
    }

    private long getMask(String maskString) {
        String[] tokens = maskString.split("&");
        if (tokens.length < 2) {
            return 0xFFFFFFFFL;
        }
        if (tokens[1].startsWith("0x")) {
            return Long.parseLong(tokens[1].substring(2).trim(), 16);
        }
        if (tokens[1].startsWith("0")) {
            return Long.parseLong(tokens[1], 8);
        }
        return Long.parseLong(tokens[1]);
    }

    private boolean matchByte(ByteBuffer bbuf) throws IOException {
        short found = (short)(bbuf.get(0) & 0xFF & (short)this.getMask(this.typeStr));
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            return (long)found == this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            return (long)found != this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            return (long)found > this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            return (long)found < this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.AND)) {
            boolean result = ((long)found & this.contentNumber) == this.contentNumber;
            return result;
        }
        if (this.operation.equals(MagicMimeEntryOperation.ANY)) {
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.CLEAR)) {
            long maskedFound = (long)found & this.contentNumber;
            boolean result = (maskedFound ^ this.contentNumber) == 0L;
            return result;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NEGATED)) {
            int negatedFound = ~found;
            return (long)negatedFound == this.contentNumber;
        }
        return false;
    }

    private boolean matchShort(ByteBuffer bbuf, ByteOrder bo) throws IOException {
        bbuf.order(bo);
        int found = bbuf.getShort() & 0xFFFF & (int)this.getMask(this.typeStr);
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            return (long)found == this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            return (long)found != this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            return (long)found > this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            return (long)found < this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.AND)) {
            boolean result = ((long)found & this.contentNumber) == this.contentNumber;
            return result;
        }
        if (this.operation.equals(MagicMimeEntryOperation.ANY)) {
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.CLEAR)) {
            long maskedFound = (long)found & this.contentNumber;
            boolean result = (maskedFound ^ this.contentNumber) == 0L;
            return result;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NEGATED)) {
            int negatedFound = ~found;
            return (long)negatedFound == this.contentNumber;
        }
        return false;
    }

    private boolean matchLong(ByteBuffer bbuf, ByteOrder bo) throws IOException {
        bbuf.order(bo);
        long found = (long)bbuf.getInt() & 0xFFFFFFFFL & this.getMask(this.typeStr);
        if (this.operation.equals(MagicMimeEntryOperation.EQUALS)) {
            return found == this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NOT_EQUALS)) {
            return found != this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.GREATER_THAN)) {
            return found > this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.LESS_THAN)) {
            return found < this.contentNumber;
        }
        if (this.operation.equals(MagicMimeEntryOperation.AND)) {
            boolean result = (found & this.contentNumber) == this.contentNumber;
            return result;
        }
        if (this.operation.equals(MagicMimeEntryOperation.ANY)) {
            return true;
        }
        if (this.operation.equals(MagicMimeEntryOperation.CLEAR)) {
            long maskedFound = found & this.contentNumber;
            boolean result = (maskedFound ^ this.contentNumber) == 0L;
            return result;
        }
        if (this.operation.equals(MagicMimeEntryOperation.NEGATED)) {
            long negatedFound = found ^ 0xFFFFFFFFFFFFFFFFL;
            return negatedFound == this.contentNumber;
        }
        return false;
    }

    private static String stringWithEscapeSubstitutions(String s) {
        StringBuffer ret = new StringBuffer();
        int len = s.length();
        int indx = 0;
        while (indx < len) {
            char c = s.charAt(indx);
            if (c == '\n') break;
            if (c == '\\') {
                if (++indx >= len) {
                    ret.append(c);
                    break;
                }
                char cn = s.charAt(indx);
                if (cn == '\\') {
                    ret.append('\\');
                } else if (cn == ' ') {
                    ret.append(' ');
                } else if (cn == 't') {
                    ret.append('\t');
                } else if (cn == 'n') {
                    ret.append('\n');
                } else if (cn == 'r') {
                    ret.append('\r');
                } else if (cn == 'x') {
                    int hexEncodedValue;
                    if ((indx += 2) >= len) {
                        ret.append(c);
                        ret.append(cn);
                        break;
                    }
                    String hexDigits = s.substring(indx - 1, indx + 1);
                    try {
                        hexEncodedValue = Integer.parseInt(hexDigits, 16);
                    }
                    catch (NumberFormatException x) {
                        ret.append(c);
                        ret.append(hexDigits);
                        break;
                    }
                    ret.append((char)hexEncodedValue);
                } else if (cn >= '0' && cn <= '7') {
                    int escape = cn - 48;
                    if (++indx >= len) {
                        ret.append((char)escape);
                        break;
                    }
                    cn = s.charAt(indx);
                    if (cn >= '0' && cn <= '7') {
                        escape <<= 3;
                        escape |= cn - 48;
                        if (++indx >= len) {
                            ret.append((char)escape);
                            break;
                        }
                        cn = s.charAt(indx);
                        if (cn >= '0' && cn <= '7') {
                            escape <<= 3;
                            escape |= cn - 48;
                        } else {
                            --indx;
                        }
                    } else {
                        --indx;
                    }
                    ret.append((char)escape);
                } else {
                    ret.append(cn);
                }
            } else {
                ret.append(c);
            }
            ++indx;
        }
        return new String(ret);
    }

    public boolean containsMimeType(String mimeType) {
        if (this.mimeType != null && this.mimeType.equals(mimeType)) {
            return true;
        }
        for (MagicMimeEntry subEntry : this.subEntries) {
            if (!subEntry.containsMimeType(mimeType)) continue;
            return true;
        }
        return false;
    }

    public MagicMimeEntry getParent() {
        return this.parent;
    }

    public List getSubEntries() {
        return Collections.unmodifiableList(this.subEntries);
    }
}

