/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.openconcerto.utils.SystemUtils;
import org.openconcerto.utils.protocol.jarjar.Handler;

public class Helper {
    private static final SystemUtils.PropertyList PL = new SystemUtils.PropertyList("java.protocol.handler.pkgs", "|");

    public static final void register() {
        PL.add(Helper.class.getPackage().getName());
    }

    public static final void unregister() {
        PL.remove(Helper.class.getPackage().getName());
    }

    public static final void setURLStreamHandlerFactory() {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.equals("jarjar")) {
                    return new Handler();
                }
                return null;
            }
        });
    }

    public static final URL intoJar(URL u) {
        return Helper.intoJar(u, "");
    }

    public static final URL intoJar(URL u, String s) {
        URL res;
        if (!u.getPath().endsWith(".jar")) {
            throw new IllegalArgumentException("Doesn't end with .jar :" + u);
        }
        if ("jar".equals(u.getProtocol())) {
            try {
                res = new URL("jar:jar" + u.toExternalForm().replace('!', '^') + "!/" + s);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Couldn't transform to jarjar " + u, e);
            }
        }
        try {
            res = new URL("jar:" + u.toExternalForm() + "!/" + s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Couldn't transform to jar URL " + u, e);
        }
        return res;
    }
}

