/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DataInputStream
extends FilterInputStream {
    private Boolean littleEndian;

    public DataInputStream(InputStream in) {
        this(in, null);
    }

    public DataInputStream(InputStream in, Boolean littleEndian) {
        super(in);
        this.littleEndian = littleEndian;
    }

    public final void setLittleEndian(Boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public final int readInt() throws IOException {
        return this.readInt(this.littleEndian);
    }

    public int readInt(boolean littleEndian) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        if (littleEndian) {
            return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public final short readShort() throws IOException {
        return this.readShort(this.littleEndian);
    }

    public short readShort(boolean littleEndian) throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)(littleEndian ? (ch2 << 8) + ch1 : (ch1 << 8) + ch2);
    }
}

