/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class Cookies {
    @GuardedBy(value="this")
    private final Map<Object, Object> map;
    @GuardedBy(value="this")
    private Map<Object, Object> collectionTypes;

    public Cookies() {
        this(8);
    }

    public Cookies(int initialCapacity) {
        this.map = new HashMap<Object, Object>(initialCapacity);
        this.collectionTypes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookies(Cookies source) {
        Cookies cookies = source;
        synchronized (cookies) {
            this.map = new HashMap<Object, Object>(source.map);
            this.collectionTypes = source.collectionTypes == null ? null : new HashMap<Object, Object>(source.collectionTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putAll(Cookies other) {
        HashMap<Object, Object> collectionTypes;
        HashMap<Object, Object> map;
        if (this == other) {
            return;
        }
        Cookies cookies = other;
        synchronized (cookies) {
            map = new HashMap<Object, Object>(other.map);
            collectionTypes = other.collectionTypes == null ? null : new HashMap<Object, Object>(other.collectionTypes);
        }
        cookies = this;
        synchronized (cookies) {
            for (Map.Entry e : map.entrySet()) {
                this.put(e.getKey(), e.getValue(), collectionTypes == null ? null : collectionTypes.get(e.getKey()));
            }
        }
    }

    public final Object put(Object k, Object v) {
        return this.put(k, v, null);
    }

    private final Object putCollectionType(Object k, Object v, Object type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.put(k, v, type);
    }

    private final synchronized Object put(Object k, Object v, Object type) {
        if (type != null) {
            if (this.collectionTypes == null) {
                this.collectionTypes = new HashMap<Object, Object>(4);
            }
            this.collectionTypes.put(k, type);
        } else if (this.collectionTypes != null) {
            this.collectionTypes.remove(k);
        }
        return this.map.put(k, v);
    }

    public final <T> Object putCollection(Object k, Collection<T> v, Class<T> clazz) {
        return this.putCollectionType(k, v, clazz);
    }

    public final <K, V> Object putMap(Object k, Map<K, V> v, Class<K> keyClass, Class<V> valueClass) {
        Objects.requireNonNull(keyClass, "Key class");
        Objects.requireNonNull(valueClass, "value class");
        return this.putCollectionType(k, v, Arrays.asList(keyClass, valueClass));
    }

    public final <T> Object putGeneric(Object k, T v, TypeToken<T> clazz) {
        return this.putCollectionType(k, v, clazz);
    }

    public final synchronized boolean containsKey(Object k) {
        return this.map.containsKey(k);
    }

    public final synchronized Object getObject(Object k) {
        return this.map.get(k);
    }

    public final int getInt(Object k) {
        return this.getObjectAs(k, Number.class).intValue();
    }

    public final long getLong(Object k) {
        return this.getObjectAs(k, Number.class).longValue();
    }

    public final Boolean getBoolean(Object k) {
        return this.getObjectAs(k, Boolean.class);
    }

    public final boolean getBoolean(Object k, boolean def) {
        Boolean res = this.getBoolean(k);
        return res == null ? def : res;
    }

    public final String getString(Object k) {
        return this.getObjectAs(k, String.class);
    }

    public final synchronized <T> T getContainedObjectAs(Object key, Class<T> clazz) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException(key + " not present in this : " + this.map.keySet());
        }
        return this.getObjectAs(key, clazz);
    }

    public final <T> T getObjectAs(Object k, Class<T> clazz) {
        return this.getObjectAs(k, clazz, null);
    }

    public final <T> T getObjectAs(Object k, Class<T> clazz, T defaultVal) {
        return this.getObjectAs(k, clazz, defaultVal, true);
    }

    public final synchronized <T> T getObjectAs(Object k, Class<T> clazz, T defaultVal, boolean useDefaultIfNullValue) {
        Object res = this.getObject(k);
        if (res == null && (useDefaultIfNullValue || !this.containsKey(k))) {
            return defaultVal;
        }
        try {
            return clazz.cast(res);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Couldn't access " + k + " in " + this + " as " + clazz.getSimpleName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> Object checkType(Object k, Object wantedType, String needMethodName) {
        Object type;
        Object object;
        Cookies cookies = this;
        synchronized (cookies) {
            object = this.getObject(k);
            type = this.collectionTypes == null ? null : this.collectionTypes.get(k);
        }
        if (object == null) {
            return null;
        }
        if (type == null) {
            throw new IllegalStateException("Wasn't stored with " + needMethodName + " : " + k);
        }
        if (!type.equals(wantedType)) {
            throw new IllegalArgumentException("Wasn't stored with the passed type : " + wantedType + " != " + type);
        }
        return object;
    }

    public final <T> Collection<T> getCollection(Object k, Class<T> clazz) {
        Object object = this.checkType(k, clazz, "putCollection()");
        Collection res = (Collection)object;
        return res;
    }

    public final <T> List<T> getList(Object k, Class<T> clazz) {
        return (List)this.getCollection(k, clazz);
    }

    public final <T> Set<T> getSet(Object k, Class<T> clazz) {
        return (Set)this.getCollection(k, clazz);
    }

    public final <K, V> Map<K, V> getMap(Object k, Class<K> keyClass, Class<V> valueClass) {
        Object object = this.checkType(k, Arrays.asList(keyClass, valueClass), "putMap()");
        Map res = (Map)object;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K, V> Map<K, V> computeMapIfAbsent(Object k, Class<K> keyClass, Class<V> valueClass, Function<Object, ? extends Map<K, V>> mappingFunction) {
        Map<K, V> res;
        Cookies cookies = this;
        synchronized (cookies) {
            res = this.getMap(k, keyClass, valueClass);
            if (res == null && (res = mappingFunction.apply(k)) != null) {
                this.putMap(k, res, keyClass, valueClass);
            }
        }
        return res;
    }

    public final <T> T getGeneric(Object k, TypeToken<T> clazz) {
        Object object;
        Object res = object = this.checkType(k, clazz, "putGeneric()");
        return (T)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T computeIfAbsent(Object k, TypeToken<T> clazz, Function<Object, ? extends T> mappingFunction) {
        T res;
        Cookies cookies = this;
        synchronized (cookies) {
            res = this.getGeneric(k, clazz);
            if (res == null && (res = mappingFunction.apply(k)) != null) {
                this.putGeneric(k, res, clazz);
            }
        }
        return res;
    }

    public synchronized String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " of " + this.map.keySet();
    }
}

