/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.openconcerto.utils.FillMode;
import org.openconcerto.utils.ImageInfo;

public class ImageUtils {
    public static BufferedImage createSmallerImage(File f, int maxWidth, int maxHeight) throws IOException {
        ImageInfo info = new ImageInfo();
        BufferedInputStream ins = new BufferedInputStream(new FileInputStream(f));
        info.setInput(ins);
        if (!info.check()) {
            throw new IllegalStateException("unable to parse the picture");
        }
        ins.close();
        int w = info.getWidth();
        int h = info.getHeight();
        if (w <= maxWidth && h <= maxHeight) {
            return null;
        }
        Image img = new ImageIcon(f.getAbsolutePath()).getImage();
        return ImageUtils.createSmallerImage(img, maxWidth, maxHeight);
    }

    public static BufferedImage createSmallerImage(Image orginalImage, int maxWidth, int maxHeight) {
        int newHeight;
        int newWidth;
        int w = orginalImage.getWidth(null);
        int h = orginalImage.getHeight(null);
        if (w <= maxWidth && h <= maxHeight) {
            return null;
        }
        float imageRatio = (float)w / (float)h;
        float finalRatio = maxWidth / maxHeight;
        if (imageRatio > finalRatio) {
            newWidth = maxWidth;
            newHeight = (int)((float)newWidth / imageRatio);
        } else {
            newHeight = maxHeight;
            newWidth = (int)((float)newHeight * imageRatio);
        }
        return ImageUtils.createQualityResizedImage(orginalImage, newWidth, newHeight);
    }

    public static BufferedImage createQualityResizedImage(Image orginalImage, float finalRatio, boolean applySoftFilter, Color bgColor, boolean fast) {
        int newWidth;
        int newHeight;
        int h;
        int w = orginalImage.getWidth(null);
        float imageRatio = (float)w / (float)(h = orginalImage.getHeight(null));
        if (finalRatio > imageRatio) {
            newHeight = h;
            newWidth = (int)((float)newHeight * finalRatio);
        } else {
            newWidth = w;
            newHeight = (int)((float)newWidth / finalRatio);
        }
        return ImageUtils.createQualityResizedImage(orginalImage, newWidth, newHeight, false, true, bgColor, fast);
    }

    public static BufferedImage createQualityResizedImage(Image orginalImage, int width, int height, boolean applySoftFilter, boolean keepRatio, Color bgColor, boolean fast) {
        return ImageUtils.createQualityResizedImage(orginalImage, width, height, applySoftFilter, keepRatio ? new FillMode.ZoomOut(bgColor) : FillMode.STRETCH, fast);
    }

    public static BufferedImage createQualityResizedImage(Image orginalImage, int width, int height, boolean applySoftFilter, FillMode fillMode, boolean fast) {
        if (orginalImage == null) {
            throw new IllegalArgumentException("null argument");
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        int quality = 4;
        if (fast) {
            quality = 2;
        }
        if (!fillMode.isRatioKept()) {
            Image resizedImage = orginalImage.getScaledInstance(width, height, quality);
            Image temp = new ImageIcon(resizedImage).getImage();
            g2.drawImage(temp, 0, 0, null);
        } else {
            float W = width;
            float H = height;
            int w = orginalImage.getWidth(null);
            int h = orginalImage.getHeight(null);
            float imageRatio = (float)w / (float)h;
            float finalRatio = W / H;
            if (fillMode instanceof FillMode.ZoomOut) {
                g2.setColor(((FillMode.ZoomOut)fillMode).getBackgroundColor());
                g2.fillRect(0, 0, width, height);
                if (finalRatio > imageRatio) {
                    int newW = Math.round(H * imageRatio);
                    int newH = Math.round(H);
                    Image resizedImage = orginalImage.getScaledInstance(newW, newH, quality);
                    Image temp = new ImageIcon(resizedImage).getImage();
                    g2.drawImage(temp, (int)((W - (float)newW) / 2.0f), 0, null);
                } else {
                    int newW = Math.round(W);
                    int newH = Math.round(W / imageRatio);
                    Image resizedImage = orginalImage.getScaledInstance(newW, newH, quality);
                    Image temp = new ImageIcon(resizedImage).getImage();
                    g2.drawImage(temp, 0, (int)((H - (float)newH) / 2.0f), null);
                }
            } else if (fillMode instanceof FillMode.ZoomIn) {
                FillMode.ZoomIn zoomIn = (FillMode.ZoomIn)fillMode;
                if (finalRatio > imageRatio) {
                    int clippedH = Math.round((float)w / finalRatio);
                    int sy1 = zoomIn.getPosition(h, clippedH);
                    int sy2 = sy1 + clippedH;
                    g2.drawImage(orginalImage, 0, 0, width, height, 0, sy1, w, sy2, null);
                } else {
                    int clippedW = Math.round((float)h * finalRatio);
                    int sx1 = zoomIn.getPosition(w, clippedW);
                    int sx2 = sx1 + clippedW;
                    g2.drawImage(orginalImage, 0, 0, width, height, sx1, 0, sx2, h, null);
                }
            }
        }
        g2.dispose();
        if (applySoftFilter) {
            return ImageUtils.getSoftFilteredImage(bufferedImage);
        }
        return bufferedImage;
    }

    public static BufferedImage createQualityResizedImage(Image orginalImage, int width, int height) {
        return ImageUtils.createQualityResizedImage(orginalImage, width, height, false, false, Color.WHITE, false);
    }

    public static BufferedImage createQualityResizedImage(Image orginalImage, int width, int height, boolean keepRatio) {
        return ImageUtils.createQualityResizedImage(orginalImage, width, height, false, keepRatio, Color.WHITE, false);
    }

    public static BufferedImage getSoftFilteredImage(BufferedImage bufferedImage) {
        float softenFactor = 0.01f;
        float[] softenArray = new float[]{0.0f, softenFactor, 0.0f, softenFactor, 1.0f - softenFactor * 3.0f, softenFactor, 0.0f, softenFactor, 0.0f};
        Kernel kernel = new Kernel(3, 3, softenArray);
        ConvolveOp cOp = new ConvolveOp(kernel, 1, null);
        bufferedImage = cOp.filter(bufferedImage, null);
        return bufferedImage;
    }
}

