/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.LightUIPanel;
import org.openconcerto.utils.io.JSONConverter;

public class LightUITab
extends LightUIPanel {
    private boolean load = false;
    private boolean forceReload = false;

    public LightUITab(String tabId, String title) {
        super(tabId);
        this.setTitle(title);
        this.setType(17);
    }

    public LightUITab(JSONObject json) {
        super(json);
    }

    public LightUITab(LightUITab tab) {
        super(tab);
        this.load = tab.load;
        this.forceReload = tab.forceReload;
    }

    public boolean isForceReload() {
        return this.forceReload;
    }

    public void setForceReload(boolean forceReload) {
        this.forceReload = forceReload;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setLoad(boolean load) {
        this.load = load;
    }

    @Override
    public void copy(LightUIElement element) {
        if (!(element instanceof LightUITab)) {
            throw new InvalidClassException(LightUITab.class.getName(), element.getClassName(), element.getId());
        }
        super.copy(element);
        LightUITab tab = (LightUITab)element;
        this.forceReload = tab.forceReload;
        this.load = tab.load;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        if (this.load) {
            json.put("load", true);
        }
        if (this.forceReload) {
            json.put("force-reload", true);
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.load = JSONConverter.getParameterFromJSON(json, "load", Boolean.class, false);
        this.forceReload = JSONConverter.getParameterFromJSON(json, "force-reload", Boolean.class, false);
    }
}

