/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.openconcerto.sql.users.User;
import org.openconcerto.task.UserTaskRight;

public class UserTaskRightListCellRenderer
extends DefaultListCellRenderer {
    public static final int READ = 0;
    public static final int MODIFY = 1;
    public static final int ADD = 2;
    public static final int VALIDATE = 3;
    private final int type;
    private List<UserTaskRight> usersRight;

    public UserTaskRightListCellRenderer(int aType) {
        this.type = aType;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        User user = (User)value;
        String newValue = String.valueOf(user.getFirstName()) + " " + user.getName();
        Component c = super.getListCellRendererComponent((JList<?>)list, newValue, index, false, cellHasFocus);
        this.setForeground(Color.LIGHT_GRAY);
        if (this.usersRight != null) {
            int i = 0;
            while (i < this.usersRight.size()) {
                UserTaskRight element = this.usersRight.get(i);
                if (element.getIdToUser() == user.getId() && (this.type == 0 && element.canRead() || this.type == 1 && element.canModify() || this.type == 2 && element.canAdd() || this.type == 3 && element.canValidate())) {
                    this.setForeground(Color.BLACK);
                }
                ++i;
            }
        }
        return c;
    }

    public void setUserTaskRight(List<UserTaskRight> l) {
        this.usersRight = l;
    }
}

