/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.search;

import java.util.List;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.utils.OrderedSet;

public class SearchList
implements SearchSpec {
    private final List<SearchSpec> items = new OrderedSet<SearchSpec>();

    public static SearchList singleton(SearchSpec item) {
        SearchList res = new SearchList();
        res.addSearchItem(item);
        return res;
    }

    public void addSearchItem(SearchSpec item) {
        this.items.add(item);
    }

    public void removeSearchItem(SearchSpec item) {
        this.items.remove(item);
    }

    @Override
    public boolean isEmpty() {
        for (SearchSpec s : this.items) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean match(Object line) {
        return this.match((List)line);
    }

    private boolean match(List<?> line) {
        boolean result = false;
        int stop = this.items.size();
        int i = 0;
        while (i < stop) {
            SearchSpec item = this.items.get(i);
            if (!item.match(line)) {
                return false;
            }
            result = true;
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.items.size() * 32);
        sb.append("SearchList:" + this.items.size() + " items");
        for (SearchSpec item : this.items) {
            sb.append("\n");
            sb.append(item);
        }
        return sb.toString();
    }
}

