/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.sqlobject;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletion;
import org.openconcerto.sql.sqlobject.SelectionRowListener;
import org.openconcerto.utils.cc.ITransformer;

public class ITextArticleWithCompletionCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final ITextArticleWithCompletion text;
    private boolean listenersInited = false;

    public ITextArticleWithCompletionCellEditor(SQLTable tableArticle, SQLTable tableARticleFournisseur) {
        this.text = new ITextArticleWithCompletion(tableArticle, tableARticleFournisseur);
        this.text.setBorder(BorderFactory.createEmptyBorder());
        this.text.getTextComp().setBorder(BorderFactory.createEmptyBorder());
    }

    private void initListener(final JTable t) {
        if (!this.listenersInited) {
            this.listenersInited = true;
            this.text.getTextComp().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 9) {
                        final int row = t.getEditingRow();
                        final int column = e.getModifiers() == 1 ? t.getEditingColumn() - 1 : t.getEditingColumn() + 1;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (t.getCellEditor() != null && t.getCellEditor().stopCellEditing() && column >= 0 && column < t.getColumnCount()) {
                                    t.setColumnSelectionInterval(column, column);
                                    t.setRowSelectionInterval(row, row);
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (t.editCellAt(row, column)) {
                                                t.getEditorComponent().requestFocusInWindow();
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    } else if (e.getKeyCode() == 32 && e.getModifiers() == 1) {
                        e.setModifiers(0);
                    }
                }
            });
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.text.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.initListener(table);
        if (value != null) {
            this.text.setText((String)value);
        } else {
            this.text.setText("");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ITextArticleWithCompletionCellEditor.this.text.getTextComp().grabFocus();
            }
        };
        SwingUtilities.invokeLater(r);
        return this.text;
    }

    public void addSelectionListener(SelectionRowListener l) {
        this.text.addSelectionListener(l);
    }

    public SQLRowAccessor getComboSelectedRow() {
        return this.text.getSelectedRow();
    }

    public void setSelectTransformer(ITransformer<SQLSelect, SQLSelect> selTrans) {
        this.text.setSelectTransformer(selTrans);
    }

    public void setWhere(Where w) {
        this.text.setWhere(w);
    }
}

