/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.sql.FieldExpander;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.OrderComparator;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSearchMode;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseSQLRequest;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.TM;

@ThreadSafe
public abstract class BaseFillSQLRequest
extends BaseSQLRequest {
    private static boolean DEFAULT_SELECT_LOCK = true;
    private final SQLTable primaryTable;
    @GuardedBy(value="this")
    private List<Path> order;
    @GuardedBy(value="this")
    private Map<Object, Where> wheres;
    @GuardedBy(value="this")
    private Where where;
    @GuardedBy(value="this")
    private Map<IFieldPath, SearchField> searchFields;
    @GuardedBy(value="this")
    private int searchLimit;
    @GuardedBy(value="this")
    private ITransformer<SQLSelect, SQLSelect> selTransf;
    @GuardedBy(value="this")
    private boolean lockSelect;
    private final SQLRowValues graph;
    @GuardedBy(value="this")
    private SQLRowValues graphToFetch;
    @GuardedBy(value="this")
    private SQLRowValuesListFetcher frozen = null;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private static final SQLTable.VirtualFields FIELDS_FOR_ORDER = SQLTable.VirtualFields.PRIMARY_KEY.union(SQLTable.VirtualFields.ORDER);

    public static final boolean getDefaultLockSelect() {
        return DEFAULT_SELECT_LOCK;
    }

    public static final void setDefaultLockSelect(boolean b) {
        DEFAULT_SELECT_LOCK = b;
    }

    public static void setupForeign(SQLRowValuesListFetcher fetcher) {
        fetcher.setFullOnly(false);
        fetcher.setIncludeForeignUndef(false);
        fetcher.setReferentsOrdered(true, true);
    }

    public static final boolean addToFetch(SQLRowValues input, Path p, Collection<String> fields) {
        assert (p == null || p.isSingleLink()) : "Graph size not sufficient to know if graph was modified";
        int graphSize = input.getGraphSize();
        SQLRowValues r = p == null ? input : input.followPathToOne(p, SQLRowValues.CreateMode.CREATE_ONE, false);
        boolean modified = input.getGraphSize() > graphSize;
        for (String f : fields) {
            if (r.getFields().contains(f)) continue;
            r.put(f, null);
            modified = true;
        }
        return modified;
    }

    public BaseFillSQLRequest(SQLRowValues graph, Where w) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.primaryTable = graph.getTable();
        this.setOrder(null);
        this.setWhere(w);
        this.searchFields = Collections.emptyMap();
        this.searchLimit = 35;
        this.selTransf = null;
        this.lockSelect = BaseFillSQLRequest.getDefaultLockSelect();
        this.graph = graph.toImmutable();
        this.graphToFetch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseFillSQLRequest(BaseFillSQLRequest req) {
        this.primaryTable = req.getPrimaryTable();
        BaseFillSQLRequest baseFillSQLRequest = req;
        synchronized (baseFillSQLRequest) {
            this.order = req.order;
            this.wheres = req.wheres;
            this.where = req.where;
            this.searchFields = req.searchFields;
            this.searchLimit = req.searchLimit;
            this.selTransf = req.selTransf;
            this.lockSelect = req.lockSelect;
            this.graph = req.getGraph();
            this.graphToFetch = req.getGraphToFetch();
        }
    }

    public final synchronized boolean isFrozen() {
        return this.frozen != null;
    }

    public final void freeze() {
        this.freeze(this);
    }

    private final synchronized void freeze(BaseFillSQLRequest from) {
        if (!this.isFrozen()) {
            this.frozen = from.getFetcher();
            assert (this.frozen.isFrozen());
            this.wasFrozen();
        }
    }

    protected void wasFrozen() {
    }

    protected final void checkFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("this has been frozen: " + this);
        }
    }

    public BaseFillSQLRequest toUnmodifiable() {
        return this.toUnmodifiableP(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T extends BaseFillSQLRequest> T toUnmodifiableP(Class<T> clazz) {
        BaseFillSQLRequest res;
        Class<?> thisClass = this.getClass();
        if (!(clazz == thisClass || thisClass.isAnonymousClass() && clazz == thisClass.getSuperclass())) {
            throw new IllegalArgumentException("Passed class isn't our class : " + clazz + " != " + thisClass);
        }
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            if (this.isFrozen()) {
                res = this;
            } else {
                res = this.clone(true);
                if (res.getClass() != clazz) {
                    throw new IllegalStateException("Clone class mismatch : " + res.getClass() + " != " + clazz);
                }
                res.freeze(this);
            }
        }
        assert (res.getClass() == clazz || res.getClass().getSuperclass() == clazz);
        BaseFillSQLRequest casted = res;
        return (T)casted;
    }

    protected abstract BaseFillSQLRequest clone(boolean var1);

    protected static final SQLRowValues computeGraph(SQLTable t, Collection<String> fields, FieldExpander exp) {
        SQLRowValues vals = new SQLRowValues(t).putNulls(fields);
        exp.expand(vals);
        return vals.toImmutable();
    }

    public final SQLRowValues getGraph() {
        return this.graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SQLRowValues getGraphToFetch() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            if (this.graphToFetch == null && this.getGraph() != null) {
                assert (!this.isFrozen()) : "no computation should take place after frozen()";
                SQLRowValues tmp = this.getGraph().deepCopy();
                this.customizeToFetch(tmp);
                this.setGraphToFetch(tmp, true);
            }
            return this.graphToFetch;
        }
    }

    public final void addToGraphToFetch(String ... fields) {
        this.addToGraphToFetch(Arrays.asList(fields));
    }

    public final void addToGraphToFetch(Collection<String> fields) {
        this.addToGraphToFetch(null, fields);
    }

    public final void addForeignToGraphToFetch(String foreignField, Collection<String> fields) {
        this.addToGraphToFetch((Path)new Path(this.getPrimaryTable()).addForeignField(foreignField), fields);
    }

    public final void addToGraphToFetch(final Path p, final Collection<String> fields) {
        this.changeGraphToFetch(new IClosure<SQLRowValues>(){

            @Override
            public void executeChecked(SQLRowValues input) {
                BaseFillSQLRequest.addToFetch(input, p, fields);
            }
        }, false);
    }

    public final void changeGraphToFetch(IClosure<SQLRowValues> cl) {
        this.changeGraphToFetch(cl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changeGraphToFetch(IClosure<SQLRowValues> cl, boolean checkNeeded) {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            SQLRowValues tmp = this.getGraphToFetch().deepCopy();
            cl.executeChecked(tmp);
            this.setGraphToFetch(tmp, checkNeeded);
        }
        this.fireWhereChange();
    }

    private final void setGraphToFetch(SQLRowValues tmp, boolean checkNeeded) {
        assert (Thread.holdsLock(this) && !this.isFrozen());
        if (checkNeeded && !tmp.graphContains(this.getGraph())) {
            throw new IllegalArgumentException("New graph too small");
        }
        this.graphToFetch = tmp.toImmutable();
    }

    protected void customizeToFetch(SQLRowValues graphToFetch) {
    }

    protected final synchronized SQLRowValuesListFetcher getFetcher() {
        if (this.isFrozen()) {
            return this.frozen;
        }
        SQLRowValues tmp = this.getGraphToFetch().deepCopy();
        for (Path orderP : this.getOrder()) {
            SQLRowValues orderVals = tmp.followPath(orderP);
            if (orderVals == null || !orderVals.getTable().isOrdered()) continue;
            orderVals.put(orderVals.getTable().getOrderField().getName(), null);
        }
        return this.setupFetcher(SQLRowValuesListFetcher.create(tmp, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SQLRowValuesListFetcher setupFetcher(SQLRowValuesListFetcher fetcher) {
        final String tableName = this.getPrimaryTable().getName();
        BaseFillSQLRequest.setupForeign(fetcher);
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            fetcher.setOrder(this.getOrder());
            fetcher.setReturnedRowsUnmodifiable(true);
            fetcher.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect sel) {
                    sel = BaseFillSQLRequest.this.transformSelect(sel);
                    if (BaseFillSQLRequest.this.isLockSelect()) {
                        sel.addLockedTable(tableName);
                    }
                    return sel.andWhere(BaseFillSQLRequest.this.getWhere());
                }
            });
            fetcher.freeze();
        }
        return fetcher;
    }

    protected final synchronized List<Path> getOrder() {
        if (this.order != null) {
            return this.order;
        }
        return this.getDefaultOrder();
    }

    public final boolean isTableOrder() {
        return this.getPrimaryTable().isOrdered() && this.getOrder().equals(this.getTableOrder());
    }

    public final int order(SQLRowValues r1, SQLRowValues r2) {
        if (r1 == r2) {
            return 0;
        }
        Comparator<SQLRowAccessor> comp = OrderComparator.getFallbackToPKInstance();
        for (Path p : this.getOrder()) {
            SQLRowValues o2;
            SQLRowValues o1 = r1.followPath(p);
            int res = comp.compare(o1, o2 = r2.followPath(p));
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public final OrderValue createOrderValue(SQLRowValues r) {
        if (!r.isFrozen()) {
            throw new IllegalArgumentException("Row not frozen : " + r);
        }
        List<Path> order = this.getOrder();
        ArrayList<SQLRow> rows = new ArrayList<SQLRow>(order.size());
        for (Path p : order) {
            rows.add(r.followPath(p).trimmedRow(FIELDS_FOR_ORDER));
        }
        return new OrderValue(Collections.unmodifiableList(rows));
    }

    protected List<Path> getDefaultOrder() {
        return this.getTableOrder();
    }

    protected final List<Path> getTableOrder() {
        return Collections.singletonList(Path.get(this.getPrimaryTable()));
    }

    public final synchronized void setOrder(List<Path> l) {
        this.checkFrozen();
        this.order = l == null ? null : Collections.unmodifiableList(new ArrayList<Path>(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putWhere(Object o, Where w) {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            HashMap<Object, Where> newValue = new HashMap<Object, Where>(this.wheres);
            if (w == null) {
                newValue.remove(o);
            } else {
                newValue.put(o, w);
            }
            this.wheres = Collections.unmodifiableMap(newValue);
            this.where = Where.and(this.wheres.values());
        }
        this.fireWhereChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWhere(Where w) {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            this.wheres = w == null ? Collections.emptyMap() : Collections.singletonMap(null, w);
            this.where = w;
        }
        this.fireWhereChange();
    }

    public final synchronized Where getWhere() {
        return this.where;
    }

    public final void setSearchable(boolean b) {
        this.setSearchFields(b ? this.getDefaultSearchFields() : Collections.emptyList());
    }

    protected Collection<SearchField> getDefaultSearchFields() {
        Set<String> names = CollectionUtils.inter(this.getGraph().getFields(), this.getPrimaryTable().getFieldsNames(SQLTable.VirtualFields.LOCAL_CONTENT));
        return this.mapOfModesToSearchFields(CollectionUtils.createMap(names));
    }

    public final void setSearchFieldsNames(Collection<String> searchFields) {
        this.setSearchFieldsNames(CollectionUtils.createMap(searchFields));
    }

    protected final Collection<SearchField> mapOfModesToSearchFields(Map<String, SQLSearchMode> searchFields) {
        ArrayList<SearchField> list = new ArrayList<SearchField>();
        for (Map.Entry<String, SQLSearchMode> e : searchFields.entrySet()) {
            list.add(new SearchField(this.getPrimaryTable().getField(e.getKey()), e.getValue() == null ? SQLSearchMode.CONTAINS : e.getValue()));
        }
        return list;
    }

    public final void setSearchFieldsNames(Map<String, SQLSearchMode> searchFields) {
        this.setSearchFields(this.mapOfModesToSearchFields(searchFields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSearchFields(Collection<SearchField> searchFields) {
        this.checkFrozen();
        HashMap<IFieldPath, SearchField> copy = new HashMap<IFieldPath, SearchField>();
        for (SearchField f : searchFields) {
            SearchField prev = copy.put(f.getField(), f);
            if (prev == null) continue;
            throw new IllegalArgumentException("Duplicate : " + f.getField());
        }
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.searchFields = Collections.unmodifiableMap(copy);
        }
        this.fireWhereChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IFieldPath, SearchField> getSearchFields() {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            return this.searchFields;
        }
    }

    public final synchronized boolean isSearchable() {
        return !this.getSearchFields().isEmpty();
    }

    public final synchronized void setSearchLimit(int limit) {
        this.searchLimit = limit;
    }

    public final synchronized int getSearchLimit() {
        return this.searchLimit;
    }

    public final synchronized void setLockSelect(boolean lockSelect) {
        this.checkFrozen();
        this.lockSelect = lockSelect;
    }

    public final synchronized boolean isLockSelect() {
        return this.lockSelect;
    }

    public Set<SQLTable> getTables() {
        HashSet<SQLTable> res = new HashSet<SQLTable>();
        for (SQLRowValues v : this.getGraphToFetch().getGraph().getItems()) {
            res.add(v.getTable());
        }
        return res;
    }

    public final void addTableListener(SQLTableModifiedListener l) {
        for (SQLTable t : this.getTables()) {
            t.addTableModifiedListener(l);
        }
    }

    public final void removeTableListener(SQLTableModifiedListener l) {
        for (SQLTable t : this.getTables()) {
            t.removeTableModifiedListener(l);
        }
    }

    protected final List<SQLField> getFields() {
        return this.getPrimaryTable().getFields((Collection<String>)this.getGraph().getFields());
    }

    protected SQLSelect transformSelect(SQLSelect sel) {
        ITransformer<SQLSelect, SQLSelect> transf = this.getSelectTransf();
        return transf == null ? sel : transf.transformChecked(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ITransformer<SQLSelect, SQLSelect> createSearchTransformer(List<String> searchQuery, final Locale l, final Where forceInclude) {
        boolean searchable;
        int searchLimit;
        Map<IFieldPath, SearchField> searchFields;
        if (searchQuery == null) {
            return null;
        }
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            searchFields = this.getSearchFields();
            searchLimit = this.getSearchLimit();
            searchable = this.isSearchable();
        }
        if (!searchable) {
            throw new IllegalArgumentException("Cannot search " + searchQuery);
        }
        final List<String> immutableQuery = Collections.unmodifiableList(new ArrayList<String>(searchQuery));
        return new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                return BaseFillSQLRequest.transformSelectSearch(sel, searchFields, searchLimit, immutableQuery, l, forceInclude);
            }
        };
    }

    protected static final SQLSelect transformSelectSearch(SQLSelect sel, Map<IFieldPath, SearchField> searchFields, int searchLimit, List<String> searchQuery, Locale l, Where forceInclude) {
        Where w;
        HashSet<String> matchScore = new HashSet<String>();
        if (!searchQuery.isEmpty()) {
            SQLSyntax syntax = sel.getSyntax();
            Where where = null;
            for (String searchTerm : searchQuery) {
                Where termWhere = null;
                for (SearchField searchField : searchFields.values()) {
                    FieldRef selF = sel.followFieldPath(searchField.getField());
                    SQLSearchMode mode = searchField.getMode();
                    List<String> formatted = searchField.format(selF, l);
                    String fieldWhere = BaseFillSQLRequest.createWhere(syntax, formatted, mode, searchTerm);
                    termWhere = Where.createRaw(fieldWhere, new FieldRef[0]).or(termWhere);
                    if (searchField.getScore() <= 0 && searchField.getHigherModes().isEmpty()) continue;
                    SQLSyntax.CaseBuilder caseBuilder = syntax.createCaseWhenBuilder().setElse("0");
                    for (Tuple2<SQLSearchMode, Integer> hm : searchField.getHigherModes()) {
                        caseBuilder.addWhen(BaseFillSQLRequest.createWhere(syntax, formatted, hm.get0(), searchTerm), String.valueOf(hm.get1()));
                    }
                    if (searchField.getScore() > 0) {
                        caseBuilder.addWhen(fieldWhere, String.valueOf(searchField.getScore()));
                    }
                    matchScore.add(caseBuilder.build());
                }
                where = Where.and(termWhere, where);
            }
            if (where != null) {
                where = where.or(forceInclude);
            }
            w = where;
        } else {
            w = null;
        }
        sel.andWhere(w);
        if (forceInclude != null) {
            matchScore.add("case when " + forceInclude + " then 10000 else 0 end");
        }
        if (!matchScore.isEmpty()) {
            sel.getOrder().add(0, String.valueOf(CollectionUtils.join(matchScore, " + ")) + " DESC");
        }
        if (searchLimit >= 0) {
            sel.setLimit(searchLimit);
        }
        return sel;
    }

    protected static final String createWhere(final SQLSyntax syntax, List<String> formatted, final SQLSearchMode mode, final String searchQuery) {
        return CollectionUtils.join(formatted, " OR ", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String sqlExpr) {
                return BaseFillSQLRequest.createWhere(sqlExpr, mode, syntax, searchQuery);
            }
        });
    }

    public static final List<String> defaultFormat(FieldRef selF, Locale l) {
        SQLType type = selF.getField().getType();
        SQLSyntax syntax = SQLSyntax.get(selF.getField());
        if (type.getJavaType() == String.class) {
            return Collections.singletonList(selF.getFieldRef());
        }
        if (type.getJavaType() == Boolean.class) {
            TM utilsTM = TM.getInstance(l);
            return Collections.singletonList("case when " + selF.getFieldRef() + " then " + syntax.quoteString(utilsTM.translate("true_key", new Object[0])) + " else " + syntax.quoteString(utilsTM.translate("false_key", new Object[0])) + " end");
        }
        if (Timestamp.class.isAssignableFrom(type.getJavaType())) {
            String shortFmt = BaseFillSQLRequest.formatTime(selF, SQLSyntax.DateProp.SHORT_DATETIME_SKELETON, l, syntax);
            String longFmt = BaseFillSQLRequest.formatTime(selF, SQLSyntax.DateProp.LONG_DATETIME_SKELETON, l, syntax);
            return Arrays.asList(shortFmt, longFmt);
        }
        if (Time.class.isAssignableFrom(type.getJavaType())) {
            return Collections.singletonList(BaseFillSQLRequest.formatTime(selF, SQLSyntax.DateProp.TIME_SKELETON, l, syntax));
        }
        if (Date.class.isAssignableFrom(type.getJavaType())) {
            String shortFmt = BaseFillSQLRequest.formatTime(selF, SQLSyntax.DateProp.SHORT_DATE_SKELETON, l, syntax);
            String longFmt = BaseFillSQLRequest.formatTime(selF, SQLSyntax.DateProp.LONG_DATE_SKELETON, l, syntax);
            return Arrays.asList(shortFmt, longFmt);
        }
        return Collections.singletonList(syntax.cast(selF.getFieldRef(), String.class));
    }

    public static final String formatTime(FieldRef selF, List<String> simpleFormat, Locale l, SQLSyntax syntax) {
        return syntax.getFormatTimestampSimple(selF.getFieldRef(), SQLSyntax.DateProp.getBestPattern(simpleFormat, l), l);
    }

    protected static final String createWhere(String sqlExpr, SQLSearchMode mode, SQLSyntax syntax, String searchQuery) {
        return "lower(" + sqlExpr + ") " + mode.generateSQL(syntax, searchQuery.toLowerCase());
    }

    public final synchronized ITransformer<SQLSelect, SQLSelect> getSelectTransf() {
        return this.selTransf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSelectTransf(ITransformer<SQLSelect, SQLSelect> transf) {
        BaseFillSQLRequest baseFillSQLRequest = this;
        synchronized (baseFillSQLRequest) {
            this.checkFrozen();
            this.selTransf = transf;
        }
        this.fireWhereChange();
    }

    public final SQLTable getPrimaryTable() {
        return this.primaryTable;
    }

    protected final void fireWhereChange() {
        assert (!Thread.holdsLock(this));
        this.supp.firePropertyChange("where", null, null);
    }

    public final void addWhereListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener("where", l);
    }

    public final void rmWhereListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener("where", l);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " on " + this.getPrimaryTable();
    }

    public static final class OrderValue
    implements Comparable<OrderValue> {
        private final List<SQLRow> rows;

        OrderValue(List<SQLRow> rows) {
            this.rows = rows;
        }

        @Override
        public int compareTo(OrderValue o2) {
            if (this == o2) {
                return 0;
            }
            int size = this.rows.size();
            if (size != o2.rows.size()) {
                throw new IllegalArgumentException("Not same state");
            }
            Comparator<SQLRowAccessor> comp = OrderComparator.getFallbackToPKInstance();
            int i = 0;
            while (i < size) {
                SQLRow r2;
                SQLRow r1 = this.rows.get(i);
                int res = comp.compare(r1, r2 = o2.rows.get(i));
                if (res != 0) {
                    return res;
                }
                ++i;
            }
            return 0;
        }
    }

    public static class SearchField {
        private final IFieldPath field;
        private final SQLSearchMode mode;
        private final int score;
        private final List<Tuple2<SQLSearchMode, Integer>> higherModes;

        public SearchField(IFieldPath field, SQLSearchMode mode) {
            this(field, mode, 1);
        }

        public SearchField(IFieldPath field, SQLSearchMode mode, int score) {
            this(field, mode, score, -1, -1);
        }

        public SearchField(IFieldPath field, SQLSearchMode mode, int score, int score2, int score3) {
            List higherModes;
            if (field.getField().getFieldGroup().getKeyType() != null) {
                throw new IllegalArgumentException("Field is a key : " + field);
            }
            this.field = field;
            this.mode = mode;
            if (score < 1) {
                throw new IllegalArgumentException("Invalid score : " + score);
            }
            this.score = score;
            List<Object> list = higherModes = field.getField().getType().getJavaType() == String.class ? this.mode.getHigherModes() : Collections.emptyList();
            if (higherModes.isEmpty()) {
                this.higherModes = Collections.emptyList();
            } else {
                if (higherModes.size() > 2) {
                    throw new IllegalStateException("Too many higher modes " + higherModes);
                }
                ArrayList<Tuple2<SQLSearchMode, Integer>> tmp = new ArrayList<Tuple2<SQLSearchMode, Integer>>(2);
                tmp.add(Tuple2.create((SQLSearchMode)higherModes.get(0), score3 < 1 ? Math.max((int)((double)this.score * 1.5), this.score + 2) : score3));
                if (higherModes.size() > 1) {
                    tmp.add(Tuple2.create((SQLSearchMode)higherModes.get(1), score2 < 1 ? Math.max((int)((double)this.score * 1.2), this.score + 1) : score2));
                }
                this.higherModes = Collections.unmodifiableList(tmp);
            }
        }

        public final IFieldPath getField() {
            return this.field;
        }

        public final SQLSearchMode getMode() {
            return this.mode;
        }

        public final int getScore() {
            return this.score;
        }

        public List<Tuple2<SQLSearchMode, Integer>> getHigherModes() {
            return this.higherModes;
        }

        protected List<String> format(FieldRef selF, Locale l) {
            if (this.getField().getField() != selF.getField()) {
                throw new IllegalArgumentException("Wrong field");
            }
            return BaseFillSQLRequest.defaultFormat(selF, l);
        }
    }
}

