/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class DocumentationEditorFrame
extends JFrame {
    public DocumentationEditorFrame(final BaseSQLComponent sqlComponent, final String itemName) {
        this.setTitle("Documentation");
        JPanel p = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.addLine(p, c, "Identifiant", new JLabel(itemName));
        RowItemDesc rivDesc = sqlComponent.getRIVDesc(itemName);
        final JTextField labelTxt = new JTextField();
        labelTxt.setText(rivDesc.getLabel());
        this.addLine(p, c, "Nom", labelTxt);
        final JTextField titleTxt = new JTextField();
        titleTxt.setText(rivDesc.getTitleLabel());
        this.addLine(p, c, "Titre de colonne", titleTxt);
        final JTextArea docTxt = new JTextArea();
        docTxt.setFont(new JTextField().getFont());
        c.weighty = 1.0;
        docTxt.setText(rivDesc.getDocumentation());
        JScrollPane comp = new JScrollPane(docTxt);
        comp.setMinimumSize(new Dimension(400, 300));
        comp.setPreferredSize(new Dimension(400, 300));
        this.addLine(p, c, "Documentation", comp);
        JPanel btnPanel = new JPanel();
        c.gridx = 1;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 14;
        JButton bOk = new JButton("Valider");
        btnPanel.add(bOk);
        JButton bCancel = new JButton("Annuler");
        btnPanel.add(bCancel);
        p.add((Component)btnPanel, c);
        this.setContentPane(p);
        bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sqlComponent.setRIVDesc(itemName, new RowItemDesc(labelTxt.getText(), titleTxt.getText(), docTxt.getText()));
                DocumentationEditorFrame.this.dispose();
            }
        });
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationEditorFrame.this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void addLine(JPanel p, GridBagConstraints c, String label, JComponent comp) {
        c.weightx = 0.0;
        c.fill = 0;
        p.add((Component)new JLabel(label), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        p.add((Component)comp, c);
        c.gridx = 0;
        ++c.gridy;
    }
}

