/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.openconcerto.erp.config.MenuAndActions;
import org.openconcerto.erp.modules.ElementContext;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.view.SQLElementEditAction;
import org.openconcerto.sql.view.SQLElementListAction;
import org.openconcerto.ui.SwingThreadUtils;

public final class MenuContext
extends ElementContext {
    private final String moduleID;
    private final MenuAndActions menuAndActions;

    MenuContext(MenuAndActions menuAndActions, String moduleID, SQLElementDirectory dir, DBRoot root) {
        super(dir, root);
        this.moduleID = moduleID;
        this.menuAndActions = menuAndActions;
    }

    public final SQLElementEditAction createEditAction(String table) {
        return new SQLElementEditAction(this.getElement(table));
    }

    public final SQLElementListAction createListAction(String table) {
        return new SQLElementListAction(this.getElement(table));
    }

    public final void addMenuItem(Action action, String menu) {
        this.addMenuItem(action, Collections.singletonList(menu));
    }

    public final void addMenuItem(Action action, String menu, String group) {
        this.addMenuItem(action, new String[]{menu, group});
    }

    public final void addMenuItem(Action action, String ... path) {
        this.addMenuItem(action, Arrays.asList(path));
    }

    public final void addMenuItem(Action action, List<String> path) throws IllegalStateException {
        String actionID = SwingThreadUtils.getActionID(action);
        String uniqID = actionID == null || actionID.trim().length() == 0 ? String.valueOf(this.moduleID) + '/' + action.getClass().getName() : (!actionID.startsWith(this.moduleID) ? String.valueOf(this.moduleID) + '/' + actionID : actionID);
        assert (uniqID.startsWith(this.moduleID));
        this.getMenuAndActions().addMenuItem(action, uniqID, path, false);
    }

    public final MenuAndActions getMenuAndActions() {
        return this.menuAndActions;
    }
}

