/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.generationDoc.SheetInterface;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.GestionDevise;

public class ReleveChequeEmisSheet
extends SheetInterface {
    private static final SQLTable tableCheque = base.getTable("CHEQUE_FOURNISSEUR");
    private static final SQLTable tableFourn = base.getTable("FOURNISSEUR");
    private List<Integer> listeCheques;
    public static final String TEMPLATE_ID = "ReleveChequeEmis";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationReleveCheque";

    public ReleveChequeEmisSheet(List<Integer> idCheques) {
        this.mapReplace = new HashMap();
        this.mapStyleRow = new HashMap();
        this.mCell = new HashMap();
        this.row = tableCheque.getRow(idCheques.get(0));
        this.listeCheques = idCheques;
        this.init();
        this.createMap();
    }

    private void init() {
        this.modele = "ReleveChequeEmis.ods";
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected String getYear() {
        return "";
    }

    @Override
    protected void createMap() {
        long montantTotal = 0L;
        int pos = 5;
        for (Integer i : this.listeCheques) {
            SQLRow rowTmp = tableCheque.getRow(i);
            SQLRow rowFournTmp = tableFourn.getRow(rowTmp.getInt("ID_FOURNISSEUR"));
            Object nomTmp = rowFournTmp.getObject("NOM");
            this.mCell.put("B" + pos, nomTmp);
            Long montant = (Long)rowTmp.getObject("MONTANT");
            montantTotal += montant.longValue();
            this.mCell.put("L" + pos, new Double(GestionDevise.currencyToString(montant, false)));
            ++pos;
        }
        this.mCell.put("C45", (Date)this.row.getObject("DATE_DECAISSE"));
        this.mCell.put("L45", new Double(GestionDevise.currencyToString(montantTotal, false)));
    }
}

