/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jopendocument.link.Component;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.OOgenerationXML;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.sync.SyncClient;

public abstract class AbstractSheetXml
extends SheetXml {
    private File generatedOpenDocumentFile;

    public AbstractSheetXml(SQLRow row) {
        this.row = row;
    }

    @Override
    public final Future<SheetXml> createDocumentAsynchronous() {
        Callable<SheetXml> c = new Callable<SheetXml>(){

            @Override
            public SheetXml call() throws Exception {
                try {
                    String templateId;
                    final String modeleFinal = templateId = AbstractSheetXml.this.getTemplateId();
                    String langage = AbstractSheetXml.this.getRowLanguage() != null ? AbstractSheetXml.this.getRowLanguage().getString("CHEMIN") : null;
                    InputStream templateStream = TemplateManager.getInstance().getTemplate(templateId, langage, AbstractSheetXml.this.getType());
                    if (templateStream == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, "Impossible de trouver le mod\u00e8le " + modeleFinal + ". \n Le mod\u00e8le par d\u00e9faut sera utilis\u00e9!");
                            }
                        });
                        templateId = AbstractSheetXml.this.getDefaultTemplateId();
                    } else {
                        templateStream.close();
                    }
                    OOgenerationXML oXML = new OOgenerationXML(AbstractSheetXml.this.row);
                    oXML.setPostProcess(AbstractSheetXml.this.getPostProcess());
                    AbstractSheetXml.this.generatedOpenDocumentFile = oXML.createDocument(templateId, AbstractSheetXml.this.getType(), AbstractSheetXml.this.getDocumentOutputDirectory(), AbstractSheetXml.getValidFileName(AbstractSheetXml.this.getName()), AbstractSheetXml.this.getRowLanguage(), AbstractSheetXml.this.getMetaGeneration());
                    if (AbstractSheetXml.this.isRefreshFormulasRequired()) {
                        Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(AbstractSheetXml.this.generatedOpenDocumentFile, true);
                        doc.save();
                        doc.close();
                    }
                }
                catch (Exception e) {
                    DEFAULT_HANDLER.uncaughtException(null, e);
                    throw e;
                }
                catch (Throwable e) {
                    DEFAULT_HANDLER.uncaughtException(null, e);
                }
                return AbstractSheetXml.this;
            }
        };
        return runnableQueue.submit(c);
    }

    public String getType() {
        return null;
    }

    @Override
    public String getStoragePathP() {
        return StringUtils.firstUp(this.elt.getPluralName());
    }

    @Override
    public File getGeneratedFile() {
        ComptaPropsConfiguration config = ComptaPropsConfiguration.getInstanceCompta();
        File outputDirectory = this.getDocumentOutputDirectory();
        try {
            FileUtils.mkdir_p(outputDirectory);
        }
        catch (IOException e1) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le dossier " + outputDirectory.getAbsolutePath(), e1);
        }
        if (this.generatedOpenDocumentFile == null) {
            this.generatedOpenDocumentFile = new File(outputDirectory, String.valueOf(AbstractSheetXml.getValidFileName(this.getName())) + ".ods");
        }
        if (config.isOnCloud()) {
            if (this.generatedOpenDocumentFile.exists()) {
                long t = this.generatedOpenDocumentFile.lastModified();
                if (System.currentTimeMillis() - t < 10000L) {
                    return this.generatedOpenDocumentFile;
                }
            }
            String remotePath = String.valueOf(config.getSocieteID()) + "/" + this.getStoragePath();
            remotePath = remotePath.replace('\\', '/');
            SyncClient client = new SyncClient("https://" + config.getStorageServer());
            client.setVerifyHost(false);
            try {
                System.out.println("AbstractSheet: getFromCloud: " + remotePath + " " + this.generatedOpenDocumentFile.getName() + " to " + outputDirectory.getAbsolutePath());
                client.retrieveFile(outputDirectory, remotePath, this.generatedOpenDocumentFile.getName(), config.getToken());
                this.generatedOpenDocumentFile.setLastModified(System.currentTimeMillis());
            }
            catch (FileNotFoundException e) {
                System.out.println("AbstractSheet: getFromCloud: " + remotePath + " " + this.generatedOpenDocumentFile.getName() + " not found on server");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.generatedOpenDocumentFile;
    }
}

