/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.action;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateIListFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.sales.order.element.CommandeClientElementSQLElement;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.Tuple2;

public class ListeDesCommandesClientItemsAction
extends CreateIListFrameAbstractAction<CommandeClientElementSQLElement> {
    public ListeDesCommandesClientItemsAction(ComptaPropsConfiguration conf) {
        super(conf, CommandeClientElementSQLElement.class);
    }

    protected SQLTableModelSource createTableSource() {
        SQLTableModelSource res = super.createTableSource();
        res.getReq().setWhere(new Where((FieldRef)((CommandeClientElementSQLElement)this.getElem()).getTable().getField("ID_COMMANDE_CLIENT"), ">", 1));
        return res;
    }

    protected IListPanel instantiateListPanel(SQLTableModelSource tableSource, String panelVariant) {
        return new ListeViewPanel(tableSource.getElem(), new IListe(tableSource));
    }

    protected void initFrame(IListFrame frame) {
        super.initFrame((JFrame)frame);
        SQLElement element = this.getElem();
        IListPanel listeAddPanel = frame.getPanel();
        SQLTableModelSource tableSource = listeAddPanel.getListe().getSource();
        final Set<FieldPath> paths = FieldPath.create(new Path(((CommandeClientElementSQLElement)this.getElem()).getTable()), Arrays.asList("QTE", "QTE_UNITAIRE", "QTE_LIVREE"));
        BaseSQLTableModelColumn colStockR = new BaseSQLTableModelColumn("Qt\u00e9 restante \u00e0 livrer", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                BigDecimal qteAlivrer = r.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(r.getInt("QTE")));
                BigDecimal qteLivree = BigDecimal.ZERO;
                if (r.getObject("QTE_LIVREE") != null) {
                    qteLivree = r.getBigDecimal("QTE_LIVREE");
                }
                return qteAlivrer.subtract(qteLivree);
            }

            @Override
            public Set<FieldPath> getPaths() {
                return paths;
            }
        };
        tableSource.getColumns().add(colStockR);
        ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> listField = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>();
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("QTE")), IListTotalPanel.Type.SOMME_QTE));
        listField.add(Tuple2.create(colStockR, IListTotalPanel.Type.SOMME_QTE));
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("T_PA_HT")), IListTotalPanel.Type.SOMME));
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("T_PV_HT")), IListTotalPanel.Type.SOMME));
        listField.add(Tuple2.create(tableSource.getColumn(element.getTable().getField("T_PV_TTC")), IListTotalPanel.Type.SOMME));
        IListTotalPanel total = new IListTotalPanel(listeAddPanel.getListe(), listField, null, "Total");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 0;
        listeAddPanel.add((Component)total, c);
        frame.setTextTitle(String.valueOf(this.getValue("Name")));
        frame.getPanel().getListe().setModificationAllowed(false);
        frame.getPanel().setAddVisible(false);
        frame.getPanel().setSearchFullMode(true);
        IListFilterDatePanel datePanel = new IListFilterDatePanel(frame.getPanel().getListe(), element.getTable().getTable("COMMANDE_CLIENT").getField("DATE"), IListFilterDatePanel.getDefaultMap());
        ++c.gridy;
        c.anchor = 10;
        frame.getPanel().add((Component)datePanel, c);
    }
}

