/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.ui;

import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openconcerto.sql.State;

public class GestionChequeFrame
extends JFrame {
    private final JPanel panel;
    private TableModel model;
    private String titre;
    private boolean isLoading = false;

    public GestionChequeFrame(JPanel p, TableModel model, String title) {
        this.panel = p;
        this.titre = title;
        this.model = model;
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GestionChequeFrame.this.setTitle();
            }
        });
        State.INSTANCE.frameCreated();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                State.INSTANCE.frameHidden();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                State.INSTANCE.frameShown();
            }
        });
        this.getContentPane().setLayout(new GridLayout());
        this.getContentPane().add(this.panel);
        this.setTitle();
        this.setBounds();
        this.pack();
    }

    private String getPlural(String s, int nb) {
        return String.valueOf(nb) + " " + s + (nb > 1 ? "s" : "");
    }

    public void setIsLoading(boolean b) {
        this.isLoading = b;
        this.setTitle();
    }

    private void setTitle() {
        String title = this.titre;
        int rowCount = this.model.getRowCount();
        title = String.valueOf(title) + ", " + this.getPlural("ligne", rowCount);
        if (this.isLoading) {
            title = String.valueOf(title) + ", chargement en cours";
        }
        this.setTitle(title);
    }

    protected final void setBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode dm = ge.getDefaultScreenDevice().getDisplayMode();
        int topOffset = 50;
        if (dm.getWidth() <= 800 || dm.getHeight() <= 600) {
            this.setLocation(0, 50);
            this.setSize(dm.getWidth(), dm.getHeight() - 50);
        } else {
            this.setLocation(10, 50);
            this.setSize(dm.getWidth() - 50, dm.getHeight() - 20 - 50);
        }
    }
}

