/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.payment.element;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.ui.component.ITextCombo;
import org.openconcerto.ui.component.ImmutableITextComboCache;
import org.openconcerto.utils.CollectionUtils;

public final class SEPAMandateSQLElement
extends ComptaSQLConfElement {
    static final String TABLE_NAME = "SEPA_MANDATE";
    public static final String SEQ_FIRST = "FRST";
    public static final String SEQ_RECURRENT = "RCUR";
    public static final String SEQ_FINAL = "FNAL";
    public static final String SEQ_ONEOFF = "OOFF";
    public static final List<String> SEQ_VALUES = Arrays.asList("FRST", "RCUR", "FNAL", "OOFF");
    private static final int IDENTIFICATION_MAX_LENGTH = 35;

    public static SQLCreateTable getCreateTable(DBRoot root) {
        if (root.contains(TABLE_NAME)) {
            return null;
        }
        SQLCreateTable res = new SQLCreateTable(root, TABLE_NAME);
        res.addForeignColumn(null, root.getTable("CLIENT"));
        res.addVarCharColumn("MandateIdentification", 35);
        res.addColumn("DateOfSignature", "date", null, true);
        res.addVarCharColumn("SequenceType", 8);
        res.addBooleanColumn("ACTIVE", Boolean.TRUE, false);
        return res;
    }

    public SEPAMandateSQLElement(ComptaPropsConfiguration conf) {
        super(conf.getRootSociete().findTable(TABLE_NAME, true));
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        links.get("ID_CLIENT").setType(SQLElementLink.LinkType.PARENT);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_CLIENT");
        l.add("MandateIdentification");
        l.add("DateOfSignature");
        l.add("SequenceType");
        l.add("ACTIVE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("MandateIdentification");
        l.add("DateOfSignature");
        l.add("SequenceType");
        return l;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        return CollectionUtils.createSet("ID_CLIENT", "MandateIdentification");
    }

    @Override
    protected SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            protected void addViews() {
                this.addView("ID_CLIENT");
                this.addView("MandateIdentification");
                this.addView("DateOfSignature");
                ITextCombo seqTypeCombo = new ITextCombo(true);
                seqTypeCombo.initCache(new ImmutableITextComboCache(SEQ_VALUES));
                this.addView(seqTypeCombo, "SequenceType");
                this.addView("ACTIVE");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".SEPAMandate";
    }

    public final SQLRowValues createRecurrent(Number idClient, String mandateIdent, Date dateOfSignature) {
        SQLRowValues res = new SQLRowValues(this.getTable());
        res.put("ID_CLIENT", Objects.requireNonNull(idClient));
        if (mandateIdent.length() > 35) {
            throw new IllegalArgumentException("Identification too long (>35) : " + mandateIdent);
        }
        res.put("MandateIdentification", mandateIdent);
        res.put("DateOfSignature", Objects.requireNonNull(dateOfSignature));
        res.put("SequenceType", SEQ_FIRST);
        res.put("ACTIVE", Boolean.TRUE);
        return res;
    }

    public String generateMandateIdentification(String label, char pad, boolean padStart, boolean truncateStart) {
        String fixedLNumber;
        UUID uuid = UUID.randomUUID();
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        String uuidS = Base64.getEncoder().withoutPadding().encodeToString(byteBuffer.array()).replace('/', '.');
        assert (uuidS.length() == 22);
        if (Character.isSpaceChar(pad)) {
            throw new IllegalArgumentException("Invalid pad : spaces can be hard to debug : '" + pad + "'");
        }
        label = label.trim();
        int numberL = 10;
        int zeroesToAdd = 10 - label.length();
        if (zeroesToAdd == 0) {
            fixedLNumber = label;
        } else if (zeroesToAdd > 0) {
            StringBuilder sb = new StringBuilder(10);
            if (!padStart) {
                sb.append(label);
            }
            int i = 0;
            while (i < zeroesToAdd) {
                sb.append(pad);
                ++i;
            }
            if (padStart) {
                sb.append(label);
            }
            fixedLNumber = sb.toString();
        } else {
            String string = fixedLNumber = truncateStart ? label.substring(-zeroesToAdd, label.length()) : label.substring(0, 10);
        }
        assert (fixedLNumber.length() == 10);
        String res = String.valueOf(uuidS) + '-' + fixedLNumber;
        assert (res.length() <= 35);
        return res;
    }
}

