/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.Map3310;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.Tuple2;

public class DeclarationTVAPanel
extends JPanel {
    private JTextField textFieldTVA = new JTextField();
    private final JDate dateDebutPeriode = new JDate();
    private final JDate dateFinPeriode = new JDate();
    private JButton buttonRemplirTVA = new JButton("Remplir la d\u00e9claration");

    public DeclarationTVAPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.textFieldTVA.setEditable(false);
        JPanel panelPeriode = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.gridx = -1;
        panelPeriode.add((Component)new JLabel("P\u00e9riode du "), c2);
        panelPeriode.add((Component)this.dateDebutPeriode, c2);
        panelPeriode.add((Component)new JLabel(" au "), c2);
        c2.weightx = 1.0;
        c2.fill = 0;
        panelPeriode.add((Component)this.dateFinPeriode, c2);
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)panelPeriode, c);
        this.setUpDatePeriode();
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("G\u00e9n\u00e9ration de la d\u00e9claration de TVA (Cerfa DGI N\u00b03310)"), c);
        final JProgressBar progressBarTVA = new JProgressBar();
        ++c.gridy;
        c.weightx = 1.0;
        this.add((Component)progressBarTVA, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.buttonRemplirTVA, c);
        this.buttonRemplirTVA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Map3310 map3310 = new Map3310(progressBarTVA, DeclarationTVAPanel.this.dateDebutPeriode.getDate(), DeclarationTVAPanel.this.dateFinPeriode.getDate());
                map3310.generateMap2033A();
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 2;
        this.add((Component)new JLabel("Le document se trouvera dans le dossier :"), c);
        ++c.gridy;
        c.gridx = 0;
        JButton buttonOpenLocationTVA = new JButton(new ImageIcon(ElementComboBox.class.getResource("loupe.png")));
        this.setIconJButton(buttonOpenLocationTVA);
        buttonOpenLocationTVA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeclarationTVAPanel.this.openFolder("Location3310PDF");
            }
        });
        JPanel panelLocationTVA = new JPanel();
        panelLocationTVA.setLayout(new GridBagLayout());
        GridBagConstraints cp = new GridBagConstraints();
        cp.fill = 2;
        cp.gridheight = 1;
        cp.gridwidth = 1;
        cp.gridx = 0;
        cp.gridy = 0;
        cp.anchor = 17;
        cp.weighty = 0.0;
        cp.insets = new Insets(2, 2, 1, 2);
        cp.weightx = 1.0;
        panelLocationTVA.add((Component)this.textFieldTVA, cp);
        cp.weightx = 0.0;
        ++cp.gridx;
        cp.fill = 0;
        panelLocationTVA.add((Component)buttonOpenLocationTVA, cp);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)panelLocationTVA, c);
        JButton buttonClose = new JButton("Fermer");
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(DeclarationTVAPanel.this)).dispose();
            }
        });
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 0;
        c.anchor = 13;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)buttonClose, c);
        this.setTextLocation();
        this.dateDebutPeriode.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DeclarationTVAPanel.this.isDateValid();
            }
        });
        this.dateFinPeriode.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DeclarationTVAPanel.this.isDateValid();
            }
        });
    }

    private void setIconJButton(JButton res) {
        res.setMargin(new Insets(1, 1, 1, 1));
    }

    private void setTextLocation() {
        File f2033APDF = new File(String.valueOf(TemplateNXProps.getInstance().getStringProperty("Location3310")) + "\\" + String.valueOf(Calendar.getInstance().get(1)));
        try {
            this.textFieldTVA.setText(f2033APDF.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void openFolder(String locationProperty) {
        String file = String.valueOf(TemplateNXProps.getInstance().getStringProperty(locationProperty)) + File.separator + String.valueOf(Calendar.getInstance().get(1));
        File f = new File(file);
        try {
            FileUtils.browseFile(f);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de trouver le dossier " + f.getAbsolutePath(), e);
        }
    }

    private void setUpDatePeriode() {
        new SwingWorker<Tuple2<Date, Date>, Object>(){

            @Override
            protected Tuple2<Date, Date> doInBackground() throws Exception {
                SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
                SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
                Date dateFin = (Date)rowExercice.getObject("DATE_FIN");
                Date dateDeb = (Date)rowExercice.getObject("DATE_DEB");
                return new Tuple2<Date, Date>(dateDeb, dateFin);
            }

            @Override
            protected void done() {
                try {
                    Tuple2 t = (Tuple2)this.get();
                    DeclarationTVAPanel.this.dateDebutPeriode.setValue((Date)t.get0());
                    DeclarationTVAPanel.this.dateFinPeriode.setValue((Date)t.get1());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }.execute();
    }

    private void isDateValid() {
        System.err.println("Check date");
        Date dDeb = this.dateDebutPeriode.getDate();
        Date dEnd = this.dateFinPeriode.getDate();
        if (dDeb != null && dEnd != null) {
            boolean b = dDeb.before(dEnd);
            this.buttonRemplirTVA.setEnabled(b);
        }
    }
}

