/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.report;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercial;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class ReportingCommercialFournisseurCreator {
    private final Date deb;
    private final Date fin;
    private final DBRoot root;

    public ReportingCommercialFournisseurCreator(Date deb, Date fin, DBRoot root) {
        this.deb = deb;
        this.fin = fin;
        this.root = root;
    }

    public Collection<ReportingCommercial> getValues() {
        final SQLTable tableFacture = this.root.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLRowValues rowValues = new SQLRowValues(tableFacture);
        rowValues.putRowValues("ID_SAISIE_VENTE_FACTURE").putRowValues("ID_COMMERCIAL").putNulls("PRENOM", "NOM");
        rowValues.putRowValues("ID_ARTICLE").putRowValues("ID_FOURNISSEUR").putNulls("CODE", "NOM");
        rowValues.putNulls("T_PV_HT", "T_PV_TTC");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValues);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where(input.getJoinFromField(tableFacture.getField("ID_SAISIE_VENTE_FACTURE")).getJoinedTable().getField("DATE"), ReportingCommercialFournisseurCreator.this.deb, (Object)ReportingCommercialFournisseurCreator.this.fin);
                input.setWhere(w);
                return input;
            }
        });
        HashMap<Integer, ReportingCommercial> mapCommercial = new HashMap<Integer, ReportingCommercial>();
        List<SQLRowValues> result = fetcher.fetch();
        for (SQLRowValues sqlRowValues : result) {
            SQLRowAccessor rowArticle;
            if (sqlRowValues.isForeignEmpty("ID_ARTICLE") || (rowArticle = sqlRowValues.getForeign("ID_ARTICLE")).isForeignEmpty("ID_FOURNISSEUR")) continue;
            SQLRowAccessor rowFournisseur = rowArticle.getForeign("ID_FOURNISSEUR");
            int commercialID = sqlRowValues.getForeign("ID_SAISIE_VENTE_FACTURE").getForeignID("ID_COMMERCIAL");
            if (!mapCommercial.containsKey(commercialID)) {
                SQLRowAccessor commercialRow = sqlRowValues.getForeign("ID_SAISIE_VENTE_FACTURE").getForeign("ID_COMMERCIAL");
                mapCommercial.put(commercialID, new ReportingCommercial(String.valueOf(commercialRow.getString("PRENOM")) + " " + commercialRow.getString("NOM"), this.deb, this.fin));
            }
            ReportingCommercial r = (ReportingCommercial)mapCommercial.get(commercialID);
            BigDecimal bigDecimal = new BigDecimal(sqlRowValues.getLong("T_PV_HT")).movePointLeft(2);
            r.add(rowFournisseur.getString("NOM"), bigDecimal);
        }
        final SQLTable tableAvoir = this.root.getTable("AVOIR_CLIENT_ELEMENT");
        SQLRowValues rowValuesAvoir = new SQLRowValues(tableAvoir);
        rowValuesAvoir.putRowValues("ID_AVOIR_CLIENT").putRowValues("ID_COMMERCIAL").putNulls("PRENOM", "NOM");
        rowValuesAvoir.putRowValues("ID_ARTICLE").putRowValues("ID_FOURNISSEUR").putNulls("CODE", "NOM");
        rowValuesAvoir.putNulls("T_PV_HT", "T_PV_TTC");
        SQLRowValuesListFetcher fetcherAvoir = SQLRowValuesListFetcher.create(rowValuesAvoir);
        fetcherAvoir.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where(input.getJoinFromField(tableAvoir.getField("ID_AVOIR_CLIENT")).getJoinedTable().getField("DATE"), ReportingCommercialFournisseurCreator.this.deb, (Object)ReportingCommercialFournisseurCreator.this.fin);
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> resultA = fetcherAvoir.fetch();
        for (SQLRowValues sqlRowValues : resultA) {
            SQLRowAccessor rowArticle;
            if (sqlRowValues.isForeignEmpty("ID_ARTICLE") || (rowArticle = sqlRowValues.getForeign("ID_ARTICLE")).isForeignEmpty("ID_FOURNISSEUR")) continue;
            SQLRowAccessor rowFournisseur = rowArticle.getForeign("ID_FOURNISSEUR");
            int commercialID = sqlRowValues.getForeign("ID_AVOIR_CLIENT").getForeignID("ID_COMMERCIAL");
            if (!mapCommercial.containsKey(commercialID)) {
                SQLRowAccessor commercialRow = sqlRowValues.getForeign("ID_AVOIR_CLIENT").getForeign("ID_COMMERCIAL");
                mapCommercial.put(commercialID, new ReportingCommercial(String.valueOf(commercialRow.getString("PRENOM")) + " " + commercialRow.getString("NOM"), this.deb, this.fin));
            }
            ReportingCommercial r = (ReportingCommercial)mapCommercial.get(commercialID);
            BigDecimal bigDecimal = new BigDecimal(sqlRowValues.getLong("T_PV_HT")).movePointLeft(2).negate();
            r.add(rowFournisseur.getString("NOM"), bigDecimal);
        }
        return mapCommercial.values();
    }
}

