/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class NumberCellRenderer
extends DefaultTableCellRenderer {
    DecimalFormat decimalFormat = new DecimalFormat("##,##0.00");
    private final String suffix;

    public NumberCellRenderer() {
        this("");
    }

    public NumberCellRenderer(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(res, table, isSelected);
        ((JLabel)res).setHorizontalAlignment(4);
        if (value == null) {
            ((JLabel)res).setText("");
        } else {
            ((JLabel)res).setText(String.valueOf(this.decimalFormat.format(((Number)value).doubleValue())) + this.suffix);
        }
        return res;
    }
}

