/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class AjoutDeclinaisonTableModel
extends AbstractTableModel {
    private List<String> nomsVariants1 = new ArrayList<String>();
    private List<String> nomsVariants2 = new ArrayList<String>();
    private Integer[][] quantites = new Integer[0][0];
    private SQLRowValues[][] articles = new SQLRowValues[0][0];

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Integer.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "";
        }
        return this.nomsVariants2.get(column - 1);
    }

    @Override
    public int getRowCount() {
        return this.nomsVariants1.size();
    }

    @Override
    public int getColumnCount() {
        return this.nomsVariants2.size() + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.nomsVariants1.get(rowIndex);
        }
        return this.quantites[rowIndex][columnIndex - 1];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex > 0) {
            if (aValue == null) {
                this.quantites[rowIndex][columnIndex - 1] = 0;
            } else {
                int qte = (Integer)aValue;
                if (qte < 0) {
                    qte = 0;
                }
                this.quantites[rowIndex][columnIndex - 1] = qte;
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.quantites[rowIndex][columnIndex - 1] != null;
    }

    public boolean isMissing(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.quantites[rowIndex][columnIndex - 1] == null;
    }

    public List<SQLRowValues> getFilledArticles(SQLTable tableItem) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called from EDT");
        }
        System.err.println("AjoutDeclinaisonTableModel.getFilledArticles() table of items :" + tableItem);
        ArrayList<SQLRowValues> result = new ArrayList<SQLRowValues>();
        int s1 = this.nomsVariants1.size();
        int s2 = this.nomsVariants2.size();
        int i = 0;
        while (i < s1) {
            int j = 0;
            while (j < s2) {
                Integer qte = this.quantites[i][j];
                if (qte != null && qte > 0) {
                    int quantite = qte;
                    int idArticle = this.articles[i][j].getID();
                    SQLRowValues r = new SQLRowValues(tableItem);
                    r.put("QTE", quantite);
                    r.put("ID_ARTICLE", idArticle);
                    result.add(r);
                    System.err.println("AjoutDeclinaisonTableModel.getFilledArticles() : " + r);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void loadFrom(DBRoot root, SQLRow pere, SQLField variant1, SQLField variant2, final JTable table) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be called outsite from EDT");
        }
        SQLTable tArticle = root.getTable("ARTICLE");
        if (!pere.getTable().equals(tArticle)) {
            throw new IllegalStateException(pere + " is not from " + tArticle);
        }
        SQLRowValues graph = new SQLRowValues(tArticle);
        graph.putRowValues(variant1.getFieldName()).putNulls("NOM", "ORDRE");
        graph.putRowValues(variant2.getFieldName()).putNulls("NOM", "ORDRE");
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(graph);
        Where w = new Where((FieldRef)tArticle.getField("ID_ARTICLE_VIRTUEL_PERE"), "=", pere.getID());
        w = w.and(new Where((FieldRef)tArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
        List<SQLRowValues> values = fetcher.fetch(w);
        System.err.println("AjoutDeclinaisonTableModel.loadFrom() pere :" + pere);
        System.err.println("AjoutDeclinaisonTableModel.loadFrom() tables des variantes : " + variant1.getTable().getName() + " " + variant2.getTable().getName());
        System.err.println(String.valueOf(values.size()) + " articles : ");
        for (SQLRowValues r : values) {
            System.err.println(r);
        }
        ArrayList<SQLRowAccessor> rowsVariant1 = new ArrayList<SQLRowAccessor>();
        ArrayList<SQLRowAccessor> rowsVariant2 = new ArrayList<SQLRowAccessor>();
        for (SQLRowValues r : values) {
            SQLRowAccessor v2;
            SQLRowAccessor v1 = r.getForeign(variant1.getFieldName());
            if (v1 != null) {
                rowsVariant1.add(v1);
            }
            if ((v2 = r.getForeign(variant2.getFieldName())) == null) continue;
            rowsVariant2.add(v2);
        }
        Comparator<SQLRowAccessor> comparator = new Comparator<SQLRowAccessor>(){

            @Override
            public int compare(SQLRowAccessor o1, SQLRowAccessor o2) {
                return o1.getBigDecimal("ORDRE").compareTo(o2.getBigDecimal("ORDRE"));
            }
        };
        Collections.sort(rowsVariant1, comparator);
        Collections.sort(rowsVariant2, comparator);
        final ArrayList<String> tNomsVariants1 = new ArrayList<String>();
        HashSet<String> tNomsVariants1s = new HashSet<String>();
        HashMap<Integer, Integer> mapVariants1 = new HashMap<Integer, Integer>();
        int index = 0;
        for (SQLRowAccessor r : rowsVariant1) {
            String nom = r.getString("NOM");
            if (tNomsVariants1s.contains(nom)) continue;
            tNomsVariants1s.add(nom);
            tNomsVariants1.add(nom);
            mapVariants1.put(r.getID(), index);
            ++index;
        }
        index = 0;
        final ArrayList<String> tNomsVariants2 = new ArrayList<String>();
        HashSet<String> tNomsVariants2s = new HashSet<String>();
        HashMap<Integer, Integer> mapVariants2 = new HashMap<Integer, Integer>();
        for (SQLRowAccessor r : rowsVariant2) {
            String nom = r.getString("NOM");
            if (tNomsVariants2s.contains(nom)) continue;
            tNomsVariants2s.add(nom);
            tNomsVariants2.add(nom);
            mapVariants2.put(r.getID(), index);
            ++index;
        }
        System.err.println("AjoutDeclinaisonTableModel.loadFrom() variants 1 : " + tNomsVariants1);
        System.err.println("AjoutDeclinaisonTableModel.loadFrom() variants 2 : " + tNomsVariants2);
        final Integer[][] tQuantites = new Integer[tNomsVariants1.size()][tNomsVariants2.size()];
        final SQLRowValues[][] tArticles = new SQLRowValues[tNomsVariants1.size()][tNomsVariants2.size()];
        for (SQLRowValues r : values) {
            SQLRowAccessor v1 = r.getForeign(variant1.getFieldName());
            SQLRowAccessor v2 = r.getForeign(variant2.getFieldName());
            if (v1 == null || v2 == null) continue;
            Integer idVariant1 = v1.getID();
            Integer idVariant2 = v2.getID();
            int indexVariant1 = (Integer)mapVariants1.get(idVariant1);
            int indexVairant2 = (Integer)mapVariants2.get(idVariant2);
            tQuantites[indexVariant1][indexVairant2] = 0;
            tArticles[indexVariant1][indexVairant2] = r;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AjoutDeclinaisonTableModel.this.nomsVariants1.clear();
                AjoutDeclinaisonTableModel.this.nomsVariants1.addAll(tNomsVariants1);
                AjoutDeclinaisonTableModel.this.nomsVariants2.clear();
                AjoutDeclinaisonTableModel.this.nomsVariants2.addAll(tNomsVariants2);
                AjoutDeclinaisonTableModel.this.quantites = tQuantites;
                AjoutDeclinaisonTableModel.this.articles = tArticles;
                AjoutDeclinaisonTableModel.this.fireTableStructureChanged();
                table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        DefaultTableCellRenderer c = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (!isSelected) {
                            c.setBackground(new Color(250, 250, 250));
                            c.setForeground(Color.BLACK);
                        }
                        return c;
                    }
                });
                int i = 0;
                while (i < tNomsVariants2.size()) {
                    table.getColumnModel().getColumn(i + 1).setCellRenderer(new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            DefaultTableCellRenderer c = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            if (value == null) {
                                c.setText("");
                                c.setBackground(Color.LIGHT_GRAY);
                            } else {
                                if (!isSelected) {
                                    c.setBackground(Color.WHITE);
                                    c.setForeground(Color.BLACK);
                                }
                                c.setHorizontalAlignment(4);
                            }
                            return c;
                        }
                    });
                    ++i;
                }
                AjoutDeclinaisonTableModel.this.fireTableDataChanged();
                if (tNomsVariants1.isEmpty() || tNomsVariants2.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Aucune variante trouv\u00e9e pour cet article");
                }
            }
        });
    }
}

