/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;

public class StyleSQLElement
extends ComptaSQLConfElement {
    private Map<String, Integer> allStyleByName;
    private Map<Integer, String> allStyleByIds;

    public StyleSQLElement() {
        super("STYLE", "un style", "styles");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    public static final Map<String, Map<Integer, String>> getMapAllStyle() {
        HashMap<String, Map<Integer, String>> m = new HashMap<String, Map<Integer, String>>();
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(base.getField("STYLE.NOM"));
        String req = sel.asString();
        List l = base.getDataSource().execute(req);
        for (Map map : l) {
            Object o = map.get("NOM");
            String s = o == null ? null : o.toString();
            m.put(s, null);
        }
        m.put("BlankStyle", null);
        return m;
    }

    public final synchronized Map<String, Integer> getAllStyleByName() {
        if (this.allStyleByName == null) {
            this.allStyleByName = this.fetchAllStyleByName();
            this.getTable().addTableModifiedListener(new SQLTableModifiedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tableModified(SQLTableEvent evt) {
                    StyleSQLElement styleSQLElement = StyleSQLElement.this;
                    synchronized (styleSQLElement) {
                        StyleSQLElement.this.allStyleByName = StyleSQLElement.this.fetchAllStyleByName();
                    }
                }
            });
        }
        return this.allStyleByName;
    }

    public final Map<String, Integer> fetchAllStyleByName() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        SQLSelect sel = new SQLSelect();
        sel.addSelect(this.getTable().getField("NOM"));
        sel.addSelect(this.getTable().getKey());
        String req = sel.asString();
        List l = this.getTable().getDBSystemRoot().getDataSource().execute(req);
        for (Map map : l) {
            m.put((String)map.get("NOM"), ((Number)map.get(this.getTable().getKey().getName())).intValue());
        }
        return m;
    }

    public final Map<Integer, String> fetchAllStyleByID() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        SQLSelect sel = new SQLSelect();
        sel.addSelect(this.getTable().getKey());
        sel.addSelect(this.getTable().getField("NOM"));
        String req = sel.asString();
        List l = this.getTable().getDBSystemRoot().getDataSource().execute(req);
        for (Map map : l) {
            m.put(((Number)map.get(this.getTable().getKey().getName())).intValue(), (String)map.get("NOM"));
        }
        return m;
    }

    public final synchronized Map<Integer, String> getAllStyleByIds() {
        if (this.allStyleByIds == null) {
            this.allStyleByIds = this.fetchAllStyleByID();
            this.getTable().addTableModifiedListener(new SQLTableModifiedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void tableModified(SQLTableEvent evt) {
                    StyleSQLElement styleSQLElement = StyleSQLElement.this;
                    synchronized (styleSQLElement) {
                        StyleSQLElement.this.allStyleByIds = StyleSQLElement.this.fetchAllStyleByID();
                    }
                }
            });
        }
        return this.allStyleByIds;
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this){

            @Override
            public void addViews() {
                this.addRequiredSQLObject(new JTextField(), "NOM", "left");
                this.addRequiredSQLObject(new JTextField(), "CODE", "right");
            }
        };
    }

    @Override
    protected String createCode() {
        return "style";
    }
}

