/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.utils.Base64;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.JImage;

public class NewsChecker {
    public static void check(Properties pTOS, final File confDir, final boolean useH2) {
        if (!confDir.exists()) {
            System.out.println("missing conf dir " + confDir.getAbsolutePath());
        }
        final boolean hasCloud = pTOS.getProperty("hasCloud", "false").equals("true");
        final int launchCounter = Integer.parseInt(pTOS.getProperty("launchCounter", "0"));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block25: {
                    try {
                        File historyFile = new File(confDir, "history.log");
                        if (!historyFile.exists()) {
                            FileUtils.writeUTF8("", historyFile);
                        }
                        ArrayList<DateHash> history = new ArrayList<DateHash>();
                        long today = System.currentTimeMillis();
                        long maxDate = today - 889032704L;
                        try {
                            Throwable throwable = null;
                            Object var8_9 = null;
                            try (BufferedReader reader = new BufferedReader(new FileReader(historyFile));){
                                String line = reader.readLine();
                                while (line != null) {
                                    Long t = Long.parseLong(line);
                                    String h = reader.readLine();
                                    if (t > maxDate) {
                                        history.add(new DateHash(t, h));
                                    }
                                    line = reader.readLine();
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        byte[] data = this.download("https://www.ilm-informatique.fr/openconcerto/ocnews");
                        MessageDigest digester = MessageDigest.getInstance("SHA-256");
                        digester.update(data);
                        String h = Base64.encodeBytes(digester.digest());
                        boolean found = false;
                        for (DateHash d : history) {
                            if (!d.h.equals(h)) continue;
                            found = true;
                            break;
                        }
                        DateHash newLine = new DateHash(System.currentTimeMillis(), h);
                        history.add(newLine);
                        if (!found) {
                            JSONParser jsonParser = new JSONParser(-1);
                            String jsonString = new String(data, StandardCharsets.UTF_8);
                            JSONObject obj = (JSONObject)jsonParser.parse(jsonString);
                            String title = obj.getOrDefault("title", "").toString();
                            String text = obj.getOrDefault("text", "").toString();
                            String imageURL = obj.getOrDefault("image", "").toString();
                            String end = obj.getOrDefault("end", "1/12/2133").toString();
                            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
                            Date dateEnd = df.parse(end);
                            boolean includeCloud = obj.getOrDefault("include-cloud", Boolean.FALSE);
                            boolean includeMono = obj.getOrDefault("include-mono", Boolean.FALSE);
                            boolean includeMulti = obj.getOrDefault("include-multi", Boolean.FALSE);
                            boolean isMono = useH2;
                            boolean isMulti = !hasCloud && !isMono;
                            int minLaunch = obj.getOrDefault("min-launch", 0);
                            if (launchCounter < minLaunch) {
                                System.out.println("launch counter too small (" + launchCounter + ")");
                                break block25;
                            }
                            if (dateEnd.before(new Date())) {
                                System.out.println("outdated news");
                                break block25;
                            }
                            if (includeCloud && hasCloud || includeMono && isMono || includeMulti && isMulti) {
                                BufferedImage image = null;
                                if (imageURL != null && imageURL.length() > 5) {
                                    try {
                                        byte[] imageData = this.download(imageURL);
                                        image = ImageIO.read(new ByteArrayInputStream(imageData));
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                NewsChecker.showFrame(title, text, image, history, historyFile);
                                break block25;
                            }
                            System.out.println("news not relevant");
                            break block25;
                        }
                        System.out.println("news already displayed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }

            private byte[] download(String u) throws MalformedURLException, IOException {
                URL url = new URL(u);
                URLConnection connection = url.openConnection();
                InputStream is = connection.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[2048];
                int length = 0;
                while ((length = is.read(buffer)) != -1) {
                    out.write(buffer, 0, length);
                }
                is.close();
                out.close();
                byte[] data = out.toByteArray();
                return data;
            }
        });
        t.setPriority(1);
        t.setName("News checker");
        t.setDaemon(true);
        t.start();
    }

    protected static void showFrame(final String title, final String text, final BufferedImage image, final List<DateHash> history, final File historyFile) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame f = new JFrame();
                f.setIconImages(Gestion.getFrameIcon());
                f.setDefaultCloseOperation(0);
                if (title != null && !title.isEmpty()) {
                    f.setTitle(title);
                } else {
                    f.setTitle("OpenConcerto");
                }
                JPanel p = new JPanel();
                p.setBackground(Color.WHITE);
                p.setLayout(new BorderLayout());
                if (image != null) {
                    p.add((Component)new JImage(image), "First");
                }
                if (text != null && !text.isEmpty()) {
                    String t = text.replace("\\n", "\n");
                    JTextArea ta = new JTextArea(t);
                    ta.setBorder(BorderFactory.createLineBorder(Color.WHITE, 10));
                    Font font = new JTextField("hello").getFont();
                    font = font.deriveFont((float)font.getSize() + 2.0f);
                    ta.setFont(font);
                    ta.setEditable(false);
                    p.add((Component)ta, "Center");
                }
                final JButton bOk = new JButton();
                bOk.setEnabled(false);
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int i = 10;
                        while (i > 0) {
                            final int c = i;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    bOk.setText(String.valueOf(String.valueOf(c)) + "s");
                                }
                            });
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            --i;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                bOk.setText("OK");
                                bOk.setEnabled(true);
                                f.setDefaultCloseOperation(2);
                            }
                        });
                    }
                });
                t.start();
                bOk.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (history != null) {
                            try {
                                Throwable throwable = null;
                                Object var3_5 = null;
                                try (FileOutputStream fOp = new FileOutputStream(historyFile);){
                                    PrintStream prt = new PrintStream(new BufferedOutputStream(fOp));
                                    for (DateHash d : history) {
                                        prt.println(d.t);
                                        prt.println(d.h);
                                    }
                                    prt.close();
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            System.out.println(String.valueOf(historyFile.getAbsolutePath()) + " saved");
                        }
                        f.dispose();
                    }
                });
                FlowLayout flowLayout = new FlowLayout(2);
                JPanel pButtons = new JPanel();
                pButtons.setLayout(flowLayout);
                pButtons.setOpaque(false);
                pButtons.add(bOk);
                p.add((Component)pButtons, "Last");
                f.setContentPane(p);
                f.pack();
                f.setMinimumSize(new Dimension(300, 400));
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    NewsChecker.showFrame("Hello", "world\\nhhhf the window is enlarged or the center and the bottom.", null, null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static class DateHash {
        Long t;
        String h;

        public DateHash(Long time, String hash) {
            this.t = time;
            this.h = hash;
        }
    }
}

