/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jzlib;

import com.jcraft.jzlib.ZStream;
import com.jcraft.jzlib.ZStreamException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZInputStream
extends FilterInputStream {
    protected ZStream z = new ZStream();
    protected int bufsize = 512;
    protected int flush = 0;
    protected byte[] buf = new byte[this.bufsize];
    protected byte[] buf1 = new byte[1];
    protected boolean compress;
    protected InputStream in = null;
    private boolean nomoreinput = false;

    public ZInputStream(InputStream in) {
        this(in, false);
    }

    public ZInputStream(InputStream in, boolean nowrap) {
        super(in);
        this.in = in;
        this.z.inflateInit(nowrap);
        this.compress = false;
        this.z.next_in = this.buf;
        this.z.next_in_index = 0;
        this.z.avail_in = 0;
    }

    public ZInputStream(InputStream in, int level) {
        super(in);
        this.in = in;
        this.z.deflateInit(level);
        this.compress = true;
        this.z.next_in = this.buf;
        this.z.next_in_index = 0;
        this.z.avail_in = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.buf1, 0, 1) == -1) {
            return -1;
        }
        return this.buf1[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int err;
        if (len == 0) {
            return 0;
        }
        this.z.next_out = b;
        this.z.next_out_index = off;
        this.z.avail_out = len;
        do {
            if (this.z.avail_in == 0 && !this.nomoreinput) {
                this.z.next_in_index = 0;
                this.z.avail_in = this.in.read(this.buf, 0, this.bufsize);
                if (this.z.avail_in == -1) {
                    this.z.avail_in = 0;
                    this.nomoreinput = true;
                }
            }
            err = this.compress ? this.z.deflate(this.flush) : this.z.inflate(this.flush);
            if (this.nomoreinput && err == -5) {
                return -1;
            }
            if (err != 0 && err != 1) {
                throw new ZStreamException(String.valueOf(this.compress ? "de" : "in") + "flating: " + this.z.msg);
            }
            if (!this.nomoreinput && err != 1 || this.z.avail_out != len) continue;
            return -1;
        } while (this.z.avail_out == len && err == 0);
        return len - this.z.avail_out;
    }

    @Override
    public long skip(long n) throws IOException {
        int len = 512;
        if (n < (long)len) {
            len = (int)n;
        }
        byte[] tmp = new byte[len];
        return this.read(tmp);
    }

    public int getFlushMode() {
        return this.flush;
    }

    public void setFlushMode(int flush) {
        this.flush = flush;
    }

    public long getTotalIn() {
        return this.z.total_in;
    }

    public long getTotalOut() {
        return this.z.total_out;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

