/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.openconcerto.sql.Log;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.VariantKey;
import org.openconcerto.xml.JDOM2Utils;

@ThreadSafe
public class SQLElementNamesFromXML {
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final Set<Object> SHORT_VARIANTS = Collections.singleton(Grammar.PLURAL);
    private static final String ELEMENT_ELEM_NAME = "element";
    private static final String NAME_ID_ATTR = "refid";
    private static final String VARIANT_ATTR = "variant";
    private static final String VARIANT_REFIDS_ATTR = "refids";
    private static final String VARIANT_VALUE_ATTR = "value";
    private static final String NAME_PLURAL_ATTR = "namePlural";
    private final Locale locale;

    private static final String getNounClassAttrName(boolean shortForm) {
        return shortForm ? "nameClass" : "nounClass";
    }

    private static final void setNounClassAndBase(Element elem, Phrase phrase, boolean shortForm) {
        elem.setAttribute(SQLElementNamesFromXML.getNounClassAttrName(shortForm), phrase.getNounClass().getName());
        elem.setAttribute(shortForm ? "name" : "base", phrase.getBase());
    }

    public SQLElementNamesFromXML(Locale locale) {
        this.locale = locale;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Map<String, Phrase> load(InputStream ins) throws JDOMException, IOException {
        Document doc = new SAXBuilder().build(ins);
        return this.load(doc.getRootElement());
    }

    public final Map<String, Phrase> load(Element root) throws IOException {
        Grammar gr = Grammar.getInstance(this.getLocale());
        HashMap<String, Phrase> res = new HashMap<String, Phrase>();
        for (Element elem : root.getChildren(ELEMENT_ELEM_NAME)) {
            Map.Entry<String, Phrase> e = this.createPhrase(gr, elem);
            if (e == null) continue;
            res.put(e.getKey(), e.getValue());
        }
        return res;
    }

    public final Map.Entry<String, Phrase> createPhrase(Element elem) throws IOException {
        return this.createPhrase(Grammar.getInstance(this.getLocale()), elem);
    }

    private Map.Entry<String, Phrase> createPhrase(Grammar gr, Element elem) throws IOException {
        String base;
        String refid = elem.getAttributeValue(NAME_ID_ATTR);
        if (refid == null) {
            throw new IOException("No refid attribute");
        }
        Element nameElem = elem.getChild("name");
        boolean hasChild = nameElem != null;
        String nameAttr = elem.getAttributeValue("name");
        if (!hasChild && nameAttr == null) {
            Log.get().log(Level.FINER, "No name for code : {0}", refid);
            return null;
        }
        if (hasChild && nameAttr != null) {
            Log.get().warning("Ignoring attribute : " + nameAttr);
        }
        String string = base = hasChild ? nameElem.getAttributeValue("base") : nameAttr;
        if (base == null) {
            throw new IOException("No base for the name of " + refid);
        }
        String nounClassName = (hasChild ? nameElem : elem).getAttributeValue(SQLElementNamesFromXML.getNounClassAttrName(!hasChild));
        NounClass nounClass = nounClassName == null ? null : gr.getNounClass(nounClassName);
        Phrase res = new Phrase(gr, base, nounClass);
        if (!hasChild) {
            String plural = elem.getAttributeValue(NAME_PLURAL_ATTR);
            if (plural != null) {
                res.putVariant(Grammar.PLURAL, plural);
            }
        } else {
            for (Element variantElem : nameElem.getChildren(VARIANT_ATTR)) {
                String value = variantElem.getAttributeValue(VARIANT_VALUE_ATTR);
                if (value == null) {
                    this.warning(refid, variantElem, "No value");
                    continue;
                }
                String variantIDs = variantElem.getAttributeValue(VARIANT_REFIDS_ATTR);
                String variantPattern = variantElem.getAttributeValue("idPattern");
                if (variantIDs == null && variantPattern == null) {
                    this.warning(refid, variantElem, "No ID");
                    continue;
                }
                if (variantIDs != null) {
                    if (variantPattern != null) {
                        this.warning(refid, variantElem, "Ignorig pattern " + variantPattern);
                    }
                    String[] stringArray = SPLIT_PATTERN.split(variantIDs);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String variantID = stringArray[n2];
                        VariantKey variantKey = gr.getVariantKey(variantID);
                        if (variantKey == null) {
                            this.warning(refid, variantElem, "Ignorig " + variantID);
                        } else {
                            res.putVariant(variantKey, value);
                        }
                        ++n2;
                    }
                    continue;
                }
                assert (variantIDs == null && variantPattern != null);
                Pattern p = Pattern.compile(variantPattern);
                for (VariantKey vk : gr.getVariantKeys()) {
                    if (!p.matcher(vk.getID()).matches()) continue;
                    res.putVariant(vk, value);
                }
            }
        }
        return new AbstractMap.SimpleEntry<String, Phrase>(refid, res);
    }

    private void warning(String refid, Element variantElem, String msg) {
        Log.get().warning(String.valueOf(msg) + " for variant of " + refid + " : " + JDOM2Utils.output(variantElem));
    }

    public final Element createElement(String refID, Phrase phrase) {
        Element nameElem;
        Element elem = new Element(ELEMENT_ELEM_NAME);
        elem.setAttribute(NAME_ID_ATTR, refID);
        Set<VariantKey> explicitVariants = phrase.getExplicitVariants();
        boolean shortForm = SHORT_VARIANTS.containsAll(explicitVariants);
        if (shortForm) {
            nameElem = elem;
        } else {
            nameElem = new Element("name");
            elem.addContent(nameElem);
        }
        SQLElementNamesFromXML.setNounClassAndBase(nameElem, phrase, shortForm);
        if (!shortForm) {
            for (VariantKey explicitVariant : explicitVariants) {
                Element variantElem = new Element(VARIANT_ATTR);
                variantElem.setAttribute(VARIANT_REFIDS_ATTR, explicitVariant.getID());
                variantElem.setAttribute(VARIANT_VALUE_ATTR, phrase.getVariant(explicitVariant));
                nameElem.addContent(variantElem);
            }
        } else if (explicitVariants.contains(Grammar.PLURAL)) {
            elem.setAttribute(NAME_PLURAL_ATTR, phrase.getVariant(Grammar.PLURAL));
        }
        return elem;
    }
}

