/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public final class State {
    public static final boolean DEBUG = true;
    public static final State INSTANCE = new State();
    private final DateFormat TIME_FMT;
    private final List<String> requests = new ArrayList<String>();
    private final List<String> failed = new ArrayList<String>();
    private int failedStmts = 0;
    private int connectionTotalCount = 0;
    private int connectionCount = 0;
    private int requestsTotalCount = 0;
    private final long upDate = System.currentTimeMillis();
    private int frameCount = 0;
    private int framesVisible = 0;
    private int cacheHit = 0;

    private State() {
        this.TIME_FMT = DateFormat.getTimeInstance();
        this.TIME_FMT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    final String getFull() {
        String res = "failed requests: " + this.failed.size();
        res = String.valueOf(res) + "\nfailed statements: " + this.failedStmts;
        res = String.valueOf(res) + "\nrequests: " + this.requests.size();
        res = String.valueOf(res) + "\ntotal requests: " + this.requestsTotalCount;
        res = String.valueOf(res) + "\nconnections: " + this.connectionCount;
        res = String.valueOf(res) + "\ntotal connections: " + this.connectionTotalCount;
        res = String.valueOf(res) + "\ncache hit: " + this.cacheHit;
        res = String.valueOf(res) + "\nuptime: " + this.getUptime();
        res = String.valueOf(res) + "\n\nvisible frames: " + this.framesVisible;
        res = String.valueOf(res) + "\ntotal: " + this.frameCount;
        res = String.valueOf(res) + "\n\nhost: " + this.getHostDesc();
        return res;
    }

    private String getUptime() {
        return this.TIME_FMT.format(new Long(System.currentTimeMillis() - this.upDate));
    }

    private String getHostDesc() {
        Runtime rt = Runtime.getRuntime();
        String res = "processors: " + rt.availableProcessors();
        res = String.valueOf(res) + "\nfree memory: " + this.formatBytes(rt.freeMemory());
        res = String.valueOf(res) + "\ntotal memory: " + this.formatBytes(rt.totalMemory());
        return res;
    }

    private String formatBytes(long b) {
        return String.valueOf(b / 1024L / 1024L) + "MB";
    }

    public synchronized void beginRequest(String req) {
        this.requests.add(req);
        ++this.requestsTotalCount;
    }

    public synchronized void endRequest(String req) {
        this.requests.remove(req);
    }

    public final synchronized List<String> getRequests() {
        return new ArrayList<String>(this.requests);
    }

    public synchronized void addFailedRequest(String query) {
        this.failed.add(query);
    }

    public synchronized void addFailedStatement() {
        ++this.failedStmts;
    }

    public synchronized void connectionCreated() {
        ++this.connectionTotalCount;
        ++this.connectionCount;
    }

    public synchronized void connectionRemoved() {
        --this.connectionCount;
    }

    public synchronized void frameCreated() {
        ++this.frameCount;
    }

    public synchronized void frameShown() {
        ++this.framesVisible;
    }

    public synchronized void frameHidden() {
        --this.framesVisible;
    }

    public synchronized void addCacheHit() {
        ++this.cacheHit;
    }
}

