/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.cache.CacheItem;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.ICacheSupport;
import org.openconcerto.utils.cc.IClosure;

public class ICache<K, V, D> {
    private static final Level LEVEL = Level.FINEST;
    public static final String ITEMS_CHANGED = "itemsChanged";
    public static final String ITEM_ADDED = "itemAdded";
    public static final String ITEM_REMOVED = "itemRemoved";
    private final ICacheSupport<D> supp;
    @GuardedBy(value="this")
    private final LinkedHashMap<K, CacheItem<K, V, D>> cache;
    @GuardedBy(value="this")
    private final Map<K, CacheItem<K, V, D>> running;
    private final int delay;
    private final int size;
    private final String name;
    private ICache<K, V, D> parent;
    private final PropertyChangeSupport propSupp = new PropertyChangeSupport(this);

    public ICache() {
        this(60);
    }

    public ICache(int delay) {
        this(delay, -1);
    }

    public ICache(int delay, int size) {
        this(delay, size, null);
    }

    public ICache(int delay, int size, String name) {
        this(null, delay, size, name);
    }

    public ICache(ICacheSupport<D> supp, int delay, int size, String name) {
        this.supp = supp == null ? this.createSupp(this.getCacheSuppName(name)) : supp;
        this.running = new HashMap<K, CacheItem<K, V, D>>();
        this.delay = delay;
        if (size == 0) {
            throw new IllegalArgumentException("0 size");
        }
        this.size = size;
        this.cache = new LinkedHashMap(size < 0 ? 64 : size);
        this.name = name;
        this.parent = null;
    }

    protected ICacheSupport<D> createSupp(String name) {
        return new ICacheSupport(name);
    }

    protected String getCacheSuppName(String cacheName) {
        return cacheName;
    }

    public final ICacheSupport<D> getSupp() {
        return this.supp;
    }

    public final int getMaximumSize() {
        return this.size;
    }

    public final String getName() {
        return this.name;
    }

    public final synchronized void setParent(ICache<K, V, D> parent) {
        ICache<K, V, D> current = parent;
        while (current != null) {
            if (current == this) {
                throw new IllegalArgumentException("Cycle detected, cannot set parent to " + parent);
            }
            current = current.getParent();
        }
        this.parent = parent;
    }

    public final synchronized ICache<K, V, D> getParent() {
        return this.parent;
    }

    public final CacheResult<V> get(K sel) {
        return this.get(sel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CacheResult<V> get(K sel, boolean checkRunning) {
        ICache<K, V, D> parent = null;
        ICache iCache = this;
        synchronized (iCache) {
            CacheResult localRes;
            CacheResult cacheResult = localRes = this.cache.containsKey(sel) ? this.cache.get(sel).getResult() : CacheResult.getNotInCache();
            if (localRes.getState() == CacheResult.State.VALID) {
                this.log("IN cache", sel);
                return localRes;
            }
            if (checkRunning && this.isRunning(sel)) {
                this.log("RUNNING", sel);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return CacheResult.getInterrupted();
                }
                return this.get(sel);
            }
            if (this.parent == null) {
                this.log("NOT in cache", sel);
                return CacheResult.getNotInCache();
            }
            this.log("CALLING parent", sel);
            parent = this.parent;
        }
        return super.get(sel, false);
    }

    private final synchronized boolean addRunning(CacheItem<K, V, D> val) {
        if (!this.isRunning(val.getKey())) {
            val.addToWatchers();
            if (val.getRemovalType() == null) {
                this.running.put(val.getKey(), val);
                return true;
            }
        }
        return false;
    }

    final CacheItem<K, V, D> getRunningValFromRes(CacheResult<V> cacheRes) {
        if (cacheRes.getState() != CacheResult.State.NOT_IN_CACHE) {
            throw new IllegalArgumentException("Wrong state : " + (Object)((Object)cacheRes.getState()));
        }
        if (cacheRes.getVal() == null) {
            assert (cacheRes == CacheResult.getNotInCache());
        } else {
            if (cacheRes.getVal().getCache() != this) {
                throw new IllegalArgumentException("Not running in this cache");
            }
            assert (cacheRes.getVal().getState() == CacheItem.State.RUNNING || cacheRes.getVal().getState() == CacheItem.State.INVALID);
        }
        CacheItem<?, V, ?> res = cacheRes.getVal();
        return res;
    }

    public final synchronized void removeRunning(CacheResult<V> res) {
        this.removeRunning(this.getRunningValFromRes(res));
    }

    private final synchronized boolean removeRunning(CacheItem<K, V, D> val) {
        boolean removed;
        if (val == null) {
            return false;
        }
        K key = val.getKey();
        if (this.running.get(key) == val) {
            this.removeRunning(key);
            removed = true;
        } else {
            removed = val.setRemovalType(CacheItem.RemovalType.EXPLICIT);
        }
        assert (val.getRemovalType() != null);
        return removed;
    }

    private final synchronized void removeRunning(K key) {
        CacheItem<K, V, D> removed = this.running.remove(key);
        if (removed != null) {
            if (this.cache.get(key) != removed) {
                removed.setRemovalType(CacheItem.RemovalType.EXPLICIT);
            }
            this.notifyAll();
        }
    }

    public final synchronized boolean isRunning(K sel) {
        return this.running.containsKey(sel);
    }

    public final synchronized Set<K> getRunning() {
        return Collections.unmodifiableSet(new HashSet<K>(this.running.keySet()));
    }

    public final CacheResult<V> check(K key) {
        return this.check(key, Collections.emptySet());
    }

    public final CacheResult<V> check(K key, Set<? extends D> data) {
        return this.check(key, true, true, data);
    }

    public final CacheResult<V> check(K key, boolean readCache, boolean willWriteToCache, Set<? extends D> data) {
        return this.check(key, readCache, willWriteToCache, data, this.delay * 1000);
    }

    public final synchronized CacheResult<V> check(K key, boolean readCache, boolean willWriteToCache, Set<? extends D> data, long timeout) {
        CacheResult l;
        CacheResult cacheResult = l = readCache ? this.get(key) : CacheResult.getNotInCache();
        if (willWriteToCache && l.getState() == CacheResult.State.NOT_IN_CACHE) {
            CacheItem val = new CacheItem(this, key, data);
            if (this.addRunning(val)) {
                val.addTimeout(timeout, TimeUnit.MILLISECONDS);
                return new CacheResult(val);
            }
            assert (!val.getState().isActive()) : "active value : " + val;
        }
        return l;
    }

    public final CacheItem<K, V, D> put(K sel, V res) {
        return this.put(sel, res, Collections.emptySet());
    }

    public final CacheItem<K, V, D> put(K sel, V res, Set<? extends D> data) {
        return this.put(sel, res, data, this.delay * 1000);
    }

    public final CacheItem<K, V, D> put(K sel, V res, Set<? extends D> data, long timeoutDelay) {
        return this.put(sel, true, res, data, timeoutDelay);
    }

    private final CacheItem<K, V, D> put(K key, boolean allowReplace, V res, Set<? extends D> data, long timeoutDelay) {
        CacheItem<K, V, D> item = new CacheItem<K, V, D>(this, key, res, data);
        item.addTimeout(timeoutDelay, TimeUnit.MILLISECONDS);
        item.addToWatchers();
        return this.put(item, allowReplace);
    }

    public final CacheItem<K, V, D> put(CacheResult<V> cacheRes, V val) {
        CacheItem<K, V, D> item = this.getRunningValFromRes(cacheRes);
        if (item == null) {
            return null;
        }
        item.setValue(val);
        return this.put(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CacheItem<K, V, D> put(CacheItem<K, V, D> val, boolean allowReplace) {
        K sel = val.getKey();
        ICache iCache = this;
        synchronized (iCache) {
            boolean replacing;
            block10: {
                CacheItem.State valState;
                block9: {
                    valState = val.getState();
                    if (valState.isActive()) break block9;
                    return null;
                }
                if (valState != CacheItem.State.VALID) {
                    throw new IllegalStateException("Non valid : " + val);
                }
                boolean bl = replacing = this.cache.containsKey(sel) && this.cache.get(sel).getRemovalType() == null;
                if (allowReplace || !replacing) break block10;
                return null;
            }
            if (!replacing && this.size > 0 && this.cache.size() == this.size) {
                this.cache.values().iterator().next().setRemovalType(CacheItem.RemovalType.SIZE_LIMIT);
            }
            CacheItem<K, V, D> prev = this.cache.put(sel, val);
            if (replacing) {
                prev.setRemovalType(CacheItem.RemovalType.DATA_CHANGE);
            }
            assert (this.size <= 0 || this.cache.size() <= this.size);
            this.removeRunning(sel);
        }
        this.propSupp.firePropertyChange(new Event(this, ITEMS_CHANGED, null, null));
        this.propSupp.firePropertyChange(this.createItemEvent(ITEM_ADDED, null, val));
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRemainingTime(K key) {
        CacheItem<K, V, D> val;
        ICache iCache = this;
        synchronized (iCache) {
            val = this.cache.get(key);
        }
        if (val == null) {
            return -1L;
        }
        return val.getRemainingTimeoutDelay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putAll(ICache<K, V, D> otherCache, boolean allowReplace) {
        if (otherCache == this) {
            return;
        }
        if (otherCache.getSupp() != this.getSupp()) {
            Log.get().warning("Since both caches don't share watchers, some early events might not be notified to this cache");
        }
        ArrayList<CacheItem<K, V, D>> oItems = new ArrayList<CacheItem<K, V, D>>();
        ICache<K, V, D> iCache = otherCache;
        synchronized (iCache) {
            oItems.addAll(otherCache.cache.values());
        }
        for (CacheItem cacheItem : oItems) {
            CacheItem newItem = this.put(cacheItem.getKey(), allowReplace, cacheItem.getValue(), cacheItem.getData(), cacheItem.getRemainingTimeoutDelay());
            if (newItem == null || cacheItem.getRemovalType() != CacheItem.RemovalType.DATA_CHANGE) continue;
            newItem.setRemovalType(cacheItem.getRemovalType());
        }
    }

    public final ICache<K, V, D> copy(String name, boolean copyItems) {
        ICache<K, V, D> res = new ICache<K, V, D>(this.getSupp(), this.delay, this.getMaximumSize(), name);
        if (copyItems) {
            res.putAll(this, false);
        }
        return res;
    }

    public final synchronized void clear(K select) {
        this.log("clear", select);
        if (this.cache.containsKey(select)) {
            this.cache.get(select).setRemovalType(CacheItem.RemovalType.EXPLICIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean clear(CacheItem<K, V, D> val) {
        boolean toBeRemoved;
        boolean removedFromRunning;
        if (val.getRemovalType() == null) {
            throw new IllegalStateException("Not yet removed : " + val);
        }
        ICache iCache = this;
        synchronized (iCache) {
            this.log("clear", val);
            removedFromRunning = this.removeRunning(val);
            boolean bl = toBeRemoved = this.cache.get(val.getKey()) == val;
            if (toBeRemoved) {
                this.cache.remove(val.getKey());
            }
        }
        if (removedFromRunning || toBeRemoved) {
            this.propSupp.firePropertyChange(new Event(this, ITEMS_CHANGED, null, null));
            this.propSupp.firePropertyChange(this.createItemEvent(ITEM_REMOVED, val, null));
        }
        return toBeRemoved;
    }

    public final synchronized void clear() {
        for (CacheItem<K, V, D> val : new ArrayList<CacheItem<K, V, D>>(this.cache.values())) {
            if (val.setRemovalType(CacheItem.RemovalType.EXPLICIT)) continue;
            boolean removed = this.clear(val);
            assert (removed);
        }
        assert (this.size() == 0) : this + " expected to be empty but contains : " + this.cache.keySet();
        for (CacheItem<K, V, D> val : new ArrayList<CacheItem<K, V, D>>(this.running.values())) {
            val.setRemovalType(CacheItem.RemovalType.EXPLICIT);
        }
        assert (this.running.size() == 0) : this + " expected to have no running but contains : " + this.running.keySet();
    }

    private final void log(String msg, Object subject) {
        if (Log.get().isLoggable(LEVEL)) {
            Log.get().log(LEVEL, String.valueOf(msg) + ": " + subject);
        }
    }

    public final synchronized int size() {
        return this.cache.size();
    }

    private final Event<K, V, D> castEvent(PropertyChangeEvent evt) {
        Event casted = (Event)evt;
        if (casted.getSource() != this) {
            throw new IllegalArgumentException("Cannot uphold type safety");
        }
        Event res = casted;
        return res;
    }

    private ItemEvent<K, V, D> createItemEvent(String propertyName, CacheItem<K, V, D> oldValue, CacheItem<K, V, D> newValue) {
        if (oldValue == null && newValue == null) {
            throw new IllegalArgumentException("No values");
        }
        assert (oldValue == null || oldValue.getCache() == this);
        assert (newValue == null || newValue.getCache() == this);
        return new ItemEvent(this, propertyName, oldValue, newValue);
    }

    public final PropertyChangeListener addItemListener(final IClosure<? super ItemEvent<K, V, D>> listener) {
        return this.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt instanceof ItemEvent) {
                    listener.executeChecked((ItemEvent)ICache.this.castEvent(evt));
                }
            }
        });
    }

    public final PropertyChangeListener addListener(final IClosure<? super Event<K, V, D>> listener) {
        return this.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                listener.executeChecked(ICache.this.castEvent(evt));
            }
        });
    }

    public final PropertyChangeListener addListener(PropertyChangeListener listener) {
        this.propSupp.addPropertyChangeListener(listener);
        return listener;
    }

    public final void removeListener(PropertyChangeListener listener) {
        this.propSupp.removePropertyChangeListener(listener);
    }

    public final String toString() {
        return this.toString(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString(boolean withKeys) {
        String keys;
        if (withKeys) {
            ICache iCache = this;
            synchronized (iCache) {
                keys = ", keys cached: " + this.cache.keySet().toString();
            }
        } else {
            keys = "";
        }
        return String.valueOf(this.getClass().getName()) + " '" + this.getName() + "'" + keys;
    }

    public static class Event<K, V, D>
    extends PropertyChangeEvent {
        public Event(ICache<K, V, D> source, String propertyName, Object oldValue, Object newValue) {
            super(source, propertyName, oldValue, newValue);
        }

        @Override
        public ICache<K, V, D> getSource() {
            return (ICache)super.getSource();
        }
    }

    public static class ItemEvent<K, V, D>
    extends Event<K, V, D> {
        private ItemEvent(ICache<K, V, D> source, String propertyName, CacheItem<K, V, D> oldValue, CacheItem<K, V, D> newValue) {
            super(source, propertyName, oldValue, newValue);
        }

        @Override
        public CacheItem<K, V, D> getOldValue() {
            return (CacheItem)super.getOldValue();
        }

        @Override
        public CacheItem<K, V, D> getNewValue() {
            return (CacheItem)super.getNewValue();
        }
    }
}

