/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils;

import java.text.Format;
import java.text.ParsePosition;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.openconcerto.erp.utils.LowerCaseFormat;

public class LowerCaseFormatFilter
extends DocumentFilter {
    private final Format format = new LowerCaseFormat();
    private final Class<?> c = String.class;

    public static final boolean isValid(String s, Format f, Class<?> c) {
        ParsePosition pp = new ParsePosition(0);
        Object o = f.parseObject(s, pp);
        return c.isInstance(o) && pp.getIndex() == s.length();
    }

    private static final String subString(Document doc, int offset) throws BadLocationException {
        return doc.getText(offset, doc.getLength() - offset);
    }

    @Override
    public final void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        string = string.toLowerCase();
        String newString = String.valueOf(fb.getDocument().getText(0, offset)) + string + LowerCaseFormatFilter.subString(fb.getDocument(), offset);
        if (this.isValid(newString)) {
            fb.insertString(offset, string, attr);
        }
    }

    @Override
    public final void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        text = text.toLowerCase();
        String newString = String.valueOf(fb.getDocument().getText(0, offset)) + text + LowerCaseFormatFilter.subString(fb.getDocument(), offset + length);
        if (this.isValid(newString)) {
            fb.replace(offset, length, text, attrs);
        }
    }

    public final boolean isValid(String s) {
        return this.isPartialValid(s) || this.isCompleteValid(s);
    }

    public final boolean isCompleteValid(String s) {
        return LowerCaseFormatFilter.isValid(s, this.getFormat(), this.c);
    }

    public boolean isPartialValid(String s) {
        return false;
    }

    public String getValidationText(String s) {
        if (this.isCompleteValid(s)) {
            return String.valueOf(s) + " est valide";
        }
        if (this.isPartialValid(s)) {
            return this.getPartialValidationText(s);
        }
        return String.valueOf(s) + " n'est pas du tout valide";
    }

    protected String getPartialValidationText(String s) {
        return String.valueOf(s) + " n'est que partiellement valide";
    }

    public final Format getFormat() {
        return this.format;
    }

    public String format(Object o) {
        return this.getFormat().format(o);
    }
}

