/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.modules.DepSolverResult;
import org.openconcerto.erp.modules.DepSolverResultMM;
import org.openconcerto.erp.modules.DepSolverResultPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class DepSolverResultChooserPanel
extends JPanel {
    private JTabbedPane tabs;
    private final List<DepSolverResult> res;
    private Runnable runnable;

    public DepSolverResultChooserPanel(List<DepSolverResult> res) {
        this.res = res;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (res.size() < 1) {
            throw new IllegalArgumentException("empty solver results list");
        }
        if (res.size() == 1) {
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 2;
            c.anchor = 18;
            this.add((Component)new DepSolverResultPanel((DepSolverResultMM)res.get(0)), c);
        } else {
            this.tabs = new JTabbedPane();
            int size = res.size();
            int i = 0;
            while (i < size) {
                DepSolverResult depSolverResult = res.get(i);
                this.tabs.addTab("Solution " + (i + 1), new DepSolverResultPanel((DepSolverResultMM)depSolverResult));
                ++i;
            }
        }
        JPanel actions = new JPanel();
        actions.setLayout(new FlowLayout(2));
        JButton bOk = new JButton("Appliquer ces modifications");
        actions.add(bOk);
        JButton bCancel = new JButton("Annuler");
        actions.add(bCancel);
        bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DepSolverResultChooserPanel.this.runnable == null) {
                    throw new IllegalStateException("Missing runnable");
                }
                DepSolverResultChooserPanel.this.runnable.run();
                SwingUtilities.getWindowAncestor(DepSolverResultChooserPanel.this).dispose();
            }
        });
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getWindowAncestor(DepSolverResultChooserPanel.this).dispose();
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.fill = 2;
        this.add((Component)actions, c);
    }

    public DepSolverResultMM getSolutionToApply() {
        if (this.tabs != null) {
            return (DepSolverResultMM)this.res.get(this.tabs.getSelectedIndex());
        }
        return (DepSolverResultMM)this.res.get(0);
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }
}

