/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.generationEcritures.AssociationAnalytique;
import org.openconcerto.erp.generationEcritures.Mouvement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.User;

public class Ecriture {
    private Date date;
    private BigDecimal debit;
    private BigDecimal credit;
    private Mouvement mouvement;
    private String nom;
    private String compteNumero;
    private String compteNom;
    private Number compteID;
    private String journalNom;
    private String journalCode;
    private Number journalID;
    private List<AssociationAnalytique> associations;
    private Number id;
    private Map<String, Object> cookies;
    private boolean cloture;
    private boolean aNouveau;
    private Date dateValidation;
    private Date dateLettrage;
    private String lettrage;

    public Ecriture(Date date, BigDecimal debit, BigDecimal credit) {
        this.date = date;
        this.debit = debit;
        this.credit = credit;
    }

    public SQLInsert createInsert(DBRoot root, User user) {
        SQLInsert insert = new SQLInsert();
        SQLTable table = root.getTable("ECRITURE");
        insert.add(table.getField("DATE"), this.date);
        insert.add(table.getField("ID_MOUVEMENT"), this.mouvement.getId().intValue());
        insert.add(table.getField("DEBIT"), this.debit.multiply(new BigDecimal(100)).longValue());
        insert.add(table.getField("CREDIT"), this.credit.multiply(new BigDecimal(100)).longValue());
        insert.add(table.getField("NOM"), this.nom);
        if (this.compteNom == null) {
            throw new IllegalStateException("nom du compte manquant");
        }
        if (this.compteNumero == null || this.compteNumero.isEmpty()) {
            throw new IllegalStateException("num\u00e9ro du compte manquant");
        }
        insert.add(table.getField("ID_COMPTE_PCE"), this.compteID);
        insert.add(table.getField("COMPTE_NUMERO"), this.compteNumero);
        insert.add(table.getField("COMPTE_NOM"), this.compteNom);
        if (this.journalNom == null) {
            throw new IllegalStateException("nom du journal manquant");
        }
        if (this.journalCode == null || this.journalCode.isEmpty()) {
            throw new IllegalStateException("code du journal manquant");
        }
        insert.add(table.getField("ID_JOURNAL"), this.journalID);
        insert.add(table.getField("JOURNAL_NOM"), this.journalNom);
        insert.add(table.getField("JOURNAL_CODE"), this.journalCode);
        insert.add(table.getField("NOM_PIECE"), this.mouvement.getPiece().getNom());
        insert.add(table.getField("ID_USER_COMMON_CREATE"), user.getId());
        insert.add(table.getField("ID_USER_COMMON_MODIFY"), user.getId());
        insert.add(table.getField("CLOTURE"), this.cloture);
        insert.add(table.getField("RAN"), this.aNouveau);
        if (this.dateValidation != null) {
            insert.add(table.getField("DATE_VALIDE"), this.dateValidation);
            insert.add(table.getField("VALIDE"), Boolean.TRUE);
        } else {
            insert.add(table.getField("DATE_VALIDE"), null);
            insert.add(table.getField("VALIDE"), Boolean.FALSE);
        }
        insert.add(table.getField("DATE_LETTRAGE"), this.dateLettrage);
        insert.add(table.getField("LETTRAGE"), this.lettrage == null || this.lettrage.isEmpty() ? "" : this.lettrage);
        return insert;
    }

    public void setDateValidation(Date dateValidation) {
        this.dateValidation = dateValidation;
    }

    public void setDateLettrage(Date dateLettrage) {
        this.dateLettrage = dateLettrage;
    }

    public void setLettrage(String lettrage) {
        this.lettrage = lettrage;
    }

    public void setCloture(boolean cloture) {
        this.cloture = cloture;
    }

    public void setaNouveau(boolean aNouveau) {
        this.aNouveau = aNouveau;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    void setId(Number id) {
        this.id = id;
    }

    public Number getId() {
        return this.id;
    }

    public Number getCompteID() {
        return this.compteID;
    }

    public void setCompteID(Number compteID) {
        this.compteID = compteID;
    }

    public void setCompte(String numero, String nom) {
        this.compteNumero = numero;
        this.compteNom = nom;
    }

    public String getCompteNumero() {
        return this.compteNumero;
    }

    public String getCompteNom() {
        return this.compteNom;
    }

    public Number getJournalID() {
        return this.journalID;
    }

    public void setJournalID(Number journalID) {
        this.journalID = journalID;
    }

    public void setJournal(String code, String nom) {
        this.journalCode = code;
        this.journalNom = nom;
    }

    public String getJournalCode() {
        return this.journalCode;
    }

    public String getJournalNom() {
        return this.journalNom;
    }

    public BigDecimal getDebit() {
        return this.debit;
    }

    public BigDecimal getCredit() {
        return this.credit;
    }

    public Date getDate() {
        return this.date;
    }

    public void setMouvement(Mouvement mouvement) {
        this.mouvement = mouvement;
    }

    public List<AssociationAnalytique> getAssociationsAnalytiques() {
        return this.associations;
    }

    public void addAssociationAnalytique(AssociationAnalytique a) {
        if (this.associations == null) {
            this.associations = new ArrayList<AssociationAnalytique>();
        }
        a.setEcriture(this);
        this.associations.add(a);
    }

    public void removeAssociationAnalytique(AssociationAnalytique a) {
        if (this.associations == null) {
            a.setEcriture(null);
            return;
        }
        this.associations.remove(a);
        a.setEcriture(null);
        if (this.associations.isEmpty()) {
            this.associations = null;
        }
    }

    public boolean hasAnalytique() {
        return this.associations != null;
    }

    public void putCookie(String key, Object value) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Object>();
        }
        this.cookies.put(key, value);
    }

    public Object getCookie(String key) {
        return this.cookies.get(key);
    }

    public String toString() {
        return "Ecriture : " + this.nom + ", Compte (id:" + this.compteID + ") " + this.compteNumero + " " + this.compteNom + ", D\u00e9bit : " + this.debit + ", Cr\u00e9dit:" + this.credit;
    }
}

