/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.validation.Schema;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.xml.JDOMUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Validator {
    private final Document doc;
    private final XMLOutputter outputter;

    protected Validator(Document doc, final IPredicate<Object> foreignPredicate) {
        this.doc = doc;
        this.outputter = new XMLOutputter(Format.getRawFormat()){

            @Override
            protected void printElement(Writer out, Element element, int level, XMLOutputter.NamespaceStack namespaces) throws IOException {
                if (foreignPredicate == null || !foreignPredicate.evaluateChecked(element)) {
                    super.printElement(out, element, level, namespaces);
                }
            }

            @Override
            protected void printAttributes(Writer out, List attributes, Element parent, XMLOutputter.NamespaceStack namespaces) throws IOException {
                ArrayList<Attribute> l;
                if (foreignPredicate == null) {
                    l = attributes;
                } else {
                    int stop = attributes.size();
                    l = new ArrayList<Attribute>(stop);
                    int i = 0;
                    while (i < stop) {
                        Attribute attr = (Attribute)attributes.get(i);
                        if (!foreignPredicate.evaluateChecked(attr)) {
                            l.add(attr);
                        }
                        ++i;
                    }
                }
                super.printAttributes(out, l, parent, namespaces);
            }
        };
    }

    protected final Document getDoc() {
        return this.doc;
    }

    protected final String getDocToValidate() {
        return this.outputter.outputString(this.getDoc());
    }

    public abstract String isValid();

    public abstract Map<String, List<String>> validateCompletely();

    public static final class DTDValidator
    extends Validator {
        private final SAXBuilder b;

        public DTDValidator(Document doc) {
            this(doc, null, new SAXBuilder());
        }

        public DTDValidator(Document doc, IPredicate<Object> foreignPredicate, SAXBuilder b) {
            super(doc, foreignPredicate);
            this.b = b;
        }

        @Override
        public String isValid() {
            try {
                JDOMUtils.validateDTD(this.getDocToValidate(), this.b, null);
                return null;
            }
            catch (JDOMException e) {
                return ExceptionUtils.getStackTrace(e);
            }
        }

        @Override
        public Map<String, List<String>> validateCompletely() {
            try {
                RecordingErrorHandler recErrorHandler = new RecordingErrorHandler();
                JDOMUtils.validateDTD(this.getDocToValidate(), this.b, (ErrorHandler)recErrorHandler);
                return recErrorHandler.getMap();
            }
            catch (JDOMException e) {
                throw new IllegalStateException("Unable to read the document", e);
            }
        }
    }

    public static final class JAXPValidator
    extends Validator {
        private final Schema schema;

        public JAXPValidator(Document doc, IPredicate<Object> foreignPredicate, Schema schema) {
            super(doc, foreignPredicate);
            this.schema = schema;
        }

        @Override
        public String isValid() {
            SAXException exn = JDOMUtils.validate(this.getDocToValidate(), this.schema, null);
            if (exn == null) {
                return null;
            }
            if (exn instanceof SAXParseException) {
                return String.valueOf(exn.getLocalizedMessage()) + " " + RecordingErrorHandler.getDesc((SAXParseException)exn);
            }
            return exn.getLocalizedMessage();
        }

        @Override
        public Map<String, List<String>> validateCompletely() {
            RecordingErrorHandler recErrorHandler = new RecordingErrorHandler();
            SAXException exn = JDOMUtils.validate(this.getDocToValidate(), this.schema, (ErrorHandler)recErrorHandler);
            assert (exn == null) : "Exception thrown despite the error handler";
            return recErrorHandler.getMap();
        }
    }

    private static final class RecordingErrorHandler
    implements ErrorHandler {
        private final ListMap<String, String> res;

        private RecordingErrorHandler() {
            this(new ListMap<String, String>());
        }

        private RecordingErrorHandler(ListMap<String, String> res) {
            this.res = res;
        }

        public final ListMap<String, String> getMap() {
            return this.res;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.addExn("WARNING", e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.addExn("FATAL", e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.addExn("ERROR", e);
        }

        private void addExn(String level, SAXParseException e) {
            this.res.add(String.valueOf(level) + " " + e.getMessage(), RecordingErrorHandler.getDesc(e));
        }

        static String getDesc(SAXParseException e) {
            String f = e.getSystemId() == null ? "" : " of document " + e.getSystemId();
            return "on line " + e.getLineNumber() + ":" + e.getColumnNumber() + f;
        }
    }
}

