/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openconcerto.ui.TM;
import org.openconcerto.utils.ExceptionHandler;

public class HTMLTextField
extends JEditorPane {
    private static final ExecutorService exec = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.valueOf(HTMLTextField.class.getSimpleName()) + " Desktop thread");
            t.setDaemon(true);
            return t;
        }
    });

    public HTMLTextField(String html) {
        super("text/html", html);
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                JComponent src = (JComponent)e.getSource();
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HTMLTextField.this.linkActivated(e, src);
                } else if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    src.setToolTipText(HTMLTextField.this.getToolTip(e));
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    src.setToolTipText(null);
                }
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.setFont(new JTextField().getFont());
    }

    protected String getToolTip(HyperlinkEvent e) {
        return e.getDescription();
    }

    protected void linkActivated(final HyperlinkEvent e, final JComponent src) {
        File f;
        final URI uri = this.getURI(e);
        if (uri == null) {
            return;
        }
        if ("file".equals(uri.getScheme()) && !(f = new File(uri.getPath())).exists()) {
            JOptionPane.showMessageDialog((Component)e.getSource(), TM.tr("missingFile", f), null, 2);
            return;
        }
        exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Desktop.getDesktop().browse(uri);
                }
                catch (Exception exn) {
                    ExceptionHandler.handle(src, org.openconcerto.utils.i18n.TM.tr("linkOpenError", e.getURL()), exn);
                }
            }
        });
    }

    private URI getURI(HyperlinkEvent e) {
        try {
            return e.getURL().toURI();
        }
        catch (URISyntaxException exn) {
            ExceptionHandler.handle((Component)e.getSource(), "Couldn't get URI", exn);
            return null;
        }
    }
}

