/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.product.element;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.supplychain.product.component.ArticleFournisseurSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.FicheArticleXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.ListMap;

public class ArticleFournisseurSQLElement
extends ComptaSQLConfElement {
    public ArticleFournisseurSQLElement() {
        super("ARTICLE_FOURNISSEUR", "un article fournisseur", "articles fournisseurs");
        this.getRowActions().addAll(new MouseSheetXmlListeListener(FicheArticleXmlSheet.class).getRowActions());
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        String articleAdvanced = DefaultNXProps.getInstance().getStringProperty("ArticleModeVenteAvance");
        Boolean bArticleAdvanced = Boolean.valueOf(articleAdvanced);
        if (bArticleAdvanced.booleanValue()) {
            l.add("POIDS");
            l.add("PRIX_METRIQUE_HA_1");
            l.add("PRIX_METRIQUE_VT_1");
        }
        l.add("PA_HT");
        l.add("PV_HT");
        l.add("ID_TAXE");
        l.add("PV_TTC");
        l.add("ID_FAMILLE_ARTICLE_FOURNISSEUR");
        l.add("ID_FOURNISSEUR");
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean b = Boolean.valueOf(val);
        if (b != null && b.booleanValue()) {
            l.add("SERVICE");
        }
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"NOM", "ID_FAMILLE_ARTICLE_FOURNISSEUR"});
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.SHOW_PRODUCT_BAR_CODE, false)) {
            l.add("CODE_BARRE");
        }
        l.add("NOM");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new ArticleFournisseurSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return this.createCodeOfPackage();
    }
}

