/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.report;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingCommercial;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class ReportingCommercialCreator {
    private final Date deb;
    private final Date fin;
    private final DBRoot root;

    public ReportingCommercialCreator(Date deb, Date fin, DBRoot root) {
        this.deb = deb;
        this.fin = fin;
        this.root = root;
    }

    public Collection<ReportingCommercial> getValues() {
        final SQLTable tableFacture = this.root.getTable("SAISIE_VENTE_FACTURE");
        SQLRowValues rowValues = new SQLRowValues(tableFacture);
        rowValues.putRowValues("ID_COMMERCIAL").putNulls("PRENOM", "NOM");
        rowValues.putRowValues("ID_CLIENT").putNulls("CODE", "NOM");
        rowValues.putNulls("T_HT", "T_TTC");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValues);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)tableFacture.getField("DATE"), ReportingCommercialCreator.this.deb, (Object)ReportingCommercialCreator.this.fin);
                input.setWhere(w);
                return input;
            }
        });
        HashMap<Integer, ReportingCommercial> mapCommercial = new HashMap<Integer, ReportingCommercial>();
        List<SQLRowValues> result = fetcher.fetch();
        for (SQLRowValues sqlRowValues : result) {
            int commercialID = sqlRowValues.getForeignID("ID_COMMERCIAL");
            if (!mapCommercial.containsKey(commercialID)) {
                SQLRowAccessor commercialRow = sqlRowValues.getForeign("ID_COMMERCIAL");
                mapCommercial.put(commercialID, new ReportingCommercial(String.valueOf(commercialRow.getString("PRENOM")) + " " + commercialRow.getString("NOM"), this.deb, this.fin));
            }
            ReportingCommercial r = (ReportingCommercial)mapCommercial.get(commercialID);
            BigDecimal bigDecimal = new BigDecimal(sqlRowValues.getLong("T_HT")).movePointLeft(2);
            r.add(sqlRowValues.getForeign("ID_CLIENT").getString("NOM"), bigDecimal);
        }
        final SQLTable tableAvoir = this.root.getTable("AVOIR_CLIENT");
        SQLRowValues rowValuesAvoir = new SQLRowValues(tableAvoir);
        rowValuesAvoir.putRowValues("ID_COMMERCIAL").putNulls("PRENOM", "NOM");
        rowValuesAvoir.putRowValues("ID_CLIENT").putNulls("CODE", "NOM");
        rowValuesAvoir.putNulls("MONTANT_HT", "MONTANT_TTC");
        SQLRowValuesListFetcher fetcherAvoir = SQLRowValuesListFetcher.create(rowValuesAvoir);
        fetcherAvoir.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)tableAvoir.getField("DATE"), ReportingCommercialCreator.this.deb, (Object)ReportingCommercialCreator.this.fin);
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> resultA = fetcherAvoir.fetch();
        for (SQLRowValues sqlRowValues : resultA) {
            int commercialID = sqlRowValues.getForeignID("ID_COMMERCIAL");
            if (!mapCommercial.containsKey(commercialID)) {
                SQLRowAccessor commercialRow = sqlRowValues.getForeign("ID_COMMERCIAL");
                mapCommercial.put(commercialID, new ReportingCommercial(String.valueOf(commercialRow.getString("PRENOM")) + " " + commercialRow.getString("NOM"), this.deb, this.fin));
            }
            ReportingCommercial r = (ReportingCommercial)mapCommercial.get(commercialID);
            BigDecimal bigDecimal = new BigDecimal(sqlRowValues.getLong("MONTANT_HT")).movePointLeft(2).negate();
            r.add(sqlRowValues.getForeign("ID_CLIENT").getString("NOM"), bigDecimal);
        }
        return mapCommercial.values();
    }
}

