/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.HexDump;

public class ConcertProtocol {
    private static final char STX = '\u0002';
    private static final char ETX = '\u0003';
    private static final char EOT = '\u0004';
    private static final char ENQ = '\u0005';
    private static final char ACK = '\u0006';
    private static final char NACK = '\u0015';
    private static final char MODE_CARD = '1';
    private static final char TYPE_BUY = '0';
    public static final String CURRENCY_EUR = "978";
    private String port;
    private List<ConcertStateListener> listeners = new ArrayList<ConcertStateListener>();

    public ConcertProtocol(String port) {
        this.port = port;
    }

    public void addStateListener(ConcertStateListener listener) {
        this.listeners.add(listener);
    }

    private void fireStateChanged(ConcertStateListener.States connected) {
        for (ConcertStateListener l : this.listeners) {
            l.stateChanged(connected);
        }
    }

    public synchronized boolean sendCardPayment(int amountInCents, String currency) throws Exception {
        if (currency == null) {
            currency = CURRENCY_EUR;
        }
        return this.sendPrototolE(1, amountInCents, true, '1', '0', currency, "OpenConcerto");
    }

    public boolean sendPrototolE(int posIndex, int amountInCents, boolean requireResponse, char mode, char type, String currency, String string) throws Exception {
        byte[] buffer;
        InputStream in;
        OutputStream out;
        SerialPort serialPort;
        boolean result = false;
        if (posIndex > 99 || posIndex < 0) {
            this.fireStateChanged(ConcertStateListener.States.ERROR);
            throw new IllegalArgumentException("Pos index must be between 0 and 99");
        }
        if (amountInCents < 0) {
            this.fireStateChanged(ConcertStateListener.States.ERROR);
            throw new IllegalArgumentException("Amount must be positive");
        }
        if (currency.length() != 3) {
            this.fireStateChanged(ConcertStateListener.States.ERROR);
            throw new IllegalArgumentException("Bad currency code : " + currency);
        }
        if (this.isSerialPort()) {
            serialPort = this.getSerialPort();
            out = serialPort.getOutputStream();
            in = serialPort.getInputStream();
        } else {
            serialPort = null;
            in = new FileInputStream(this.port);
            if (in.available() > 0) {
                buffer = new byte[512];
                in.read(buffer);
                in.close();
            }
            in = new FileInputStream(this.port);
            out = new FileOutputStream(this.port);
        }
        out.write(5);
        buffer = new byte[512];
        int nbRead = in.read(buffer);
        if (nbRead != 1 || buffer[0] != 6) {
            String r = HexDump.toHex((byte[])buffer, (int)nbRead);
            in.close();
            out.close();
            if (serialPort != null) {
                serialPort.close();
            }
            this.fireStateChanged(ConcertStateListener.States.ERROR);
            throw new IllegalStateException("Bad response received : " + r);
        }
        this.fireStateChanged(ConcertStateListener.States.CONNECTED);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        bOut.write(2);
        String n = ConcertProtocol.rightAlign(posIndex, 2, '0');
        bOut.write(n.getBytes());
        bOut.write(ConcertProtocol.rightAlign(amountInCents, 8, '0').getBytes());
        if (requireResponse) {
            bOut.write(49);
        } else {
            bOut.write(48);
        }
        bOut.write(mode);
        bOut.write(type);
        bOut.write(currency.getBytes());
        bOut.write(ConcertProtocol.leftAlign(string, 10, ' ').getBytes());
        bOut.write(3);
        byte b = this.getLrc(bOut.toByteArray());
        bOut.write(b);
        out.write(bOut.toByteArray());
        nbRead = in.read(buffer);
        if (nbRead != 1 || buffer[0] != 6) {
            String r = HexDump.toHex((byte[])buffer, (int)nbRead);
            in.close();
            out.close();
            if (serialPort != null) {
                serialPort.close();
            }
            this.fireStateChanged(ConcertStateListener.States.ERROR);
            throw new IllegalStateException("Bad response received : " + nbRead + ": " + r);
        }
        out.write(4);
        this.fireStateChanged(ConcertStateListener.States.WAITING);
        int count = 0;
        int maxCount = 300;
        while (count < 300) {
            nbRead = in.read(buffer);
            if (nbRead > 0) {
                if (buffer[0] == 5) {
                    out.write(6);
                } else if (buffer[0] == 2) {
                    if (buffer[3] == 48) {
                        result = true;
                        out.write(6);
                        count = 300;
                        this.fireStateChanged(ConcertStateListener.States.OK);
                    } else if (buffer[3] == 55) {
                        out.write(21);
                        count = 300;
                        this.fireStateChanged(ConcertStateListener.States.NOK);
                    }
                } else if (buffer[0] == 4) {
                    count = 300;
                }
            }
            Thread.sleep(200L);
            ++count;
        }
        out.close();
        in.close();
        if (serialPort != null) {
            serialPort.close();
        }
        return result;
    }

    private byte getLrc(byte[] bytes) {
        byte lrc = 0;
        int i = 1;
        while (i < bytes.length) {
            lrc = (byte)(lrc ^ bytes[i]);
            ++i;
        }
        return lrc;
    }

    private boolean isSerialPort() {
        return this.port.startsWith("/dev") || this.port.startsWith("COM");
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        CommPort commPort = portIdentifier.open("CommUtil", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    private static String rightAlign(int value, int maxWidth, char fillChar) {
        String r = String.valueOf(value);
        if (r.length() > maxWidth) {
            return r.substring(0, maxWidth);
        }
        int n = maxWidth - r.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(fillChar) + r;
            ++i;
        }
        return r;
    }

    private static String leftAlign(String r, int maxWidth, char fillChar) {
        if (r.length() > maxWidth) {
            return r.substring(0, maxWidth);
        }
        int n = maxWidth - r.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(r) + fillChar;
            ++i;
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        ConcertProtocol p = new ConcertProtocol("COM9");
        p.sendCardPayment(4579, CURRENCY_EUR);
    }

    public static interface ConcertStateListener {
        public void stateChanged(States var1);

        public static enum States {
            ERROR,
            CONNECTED,
            WAITING,
            OK,
            NOK;

        }
    }
}

