/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.finance.accounting.ui.AssociationAnalytiquePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.Tuple2;

public class ListeDesEcrituresAnalytiquesAction
extends CreateFrameAbstractAction {
    public ListeDesEcrituresAnalytiquesAction() {
        this.putValue("Name", "Liste des \u00e9critures analytiques");
    }

    public JFrame createFrame() {
        SQLElement analytique = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE");
        ListeViewPanel panel = new ListeViewPanel(analytique){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints c = super.createConstraints();
                c.gridwidth = 2;
                return c;
            }

            @Override
            protected void handleAction(JButton source, ActionEvent evt) {
                if (source == this.buttonModifier) {
                    PanelFrame frameAssoc = new PanelFrame(new AssociationAnalytiquePanel(this.getListe().getSelectedRow().getForeign("ID_ECRITURE").asRow()), "Association analytique");
                    frameAssoc.setVisible(true);
                } else {
                    super.handleAction(source, evt);
                }
            }
        };
        panel.setTextButton("G\u00e9rer");
        IListFrame frame = new IListFrame(panel);
        frame.setDefaultCloseOperation(2);
        frame.getPanel().setSearchFullMode(true);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy = 4;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getInt("ID_EXERCICE_COMMON"));
        SQLTable ecritureTable = analytique.getTable().getForeignTable("ID_ECRITURE");
        IListFilterDatePanel comp = new IListFilterDatePanel(frame.getPanel().getListe(), ecritureTable.getField("DATE"), IListFilterDatePanel.getDefaultMap());
        comp.setDateDu((Date)rowExercice.getObject("DATE_DEB"));
        c.weightx = 1.0;
        frame.getPanel().add((Component)comp, c);
        ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>> fields = new ArrayList<Tuple2<? extends SQLTableModelColumn, IListTotalPanel.Type>>(2);
        List<SQLTableModelColumn> l = frame.getPanel().getListe().getSource().getColumns();
        fields.add(Tuple2.create(l.get(l.size() - 2), IListTotalPanel.Type.SOMME));
        fields.add(Tuple2.create(l.get(l.size() - 1), IListTotalPanel.Type.SOMME));
        IListTotalPanel comp2 = new IListTotalPanel(frame.getPanel().getListe(), fields, null, "Total");
        ++c.gridx;
        c.weightx = 0.0;
        frame.getPanel().add((Component)comp2, c);
        return frame;
    }
}

