/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.sync;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.net.ssl.HttpsURLConnection;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.MessageDigestUtils;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.net.HTTPClient;
import org.openconcerto.utils.sync.HashWriter;

public final class SimpleSyncClient
extends HTTPClient {
    private static final Set<Integer> GETFILE_OK_CODES = CollectionUtils.createSet(200, 404);

    protected static final long getLong(Object o) {
        return ((Number)o).longValue();
    }

    protected static final Instant getInstant(Object o) {
        return Instant.ofEpochMilli(SimpleSyncClient.getLong(o));
    }

    public SimpleSyncClient(String url) {
        super(url);
    }

    public DirContent getDir(String path) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        HttpsURLConnection con = this.openConnection("/getDir");
        HTTPClient.Response res = this.checkResponseCode(this.send(con, NetUtils.urlEncode("rp", path, "type", "json"), false));
        if (!res.isSuccess()) {
            return null;
        }
        JSONParser p = new JSONParser(144);
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream in = this.getInputStream(con);){
            return new DirContent(path, (JSONObject)p.parse(in));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public HTTPClient.Response getFile(String path, String fileName, FileConsumer fileConsumer) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        HttpsURLConnection con = this.openConnection("/get");
        this.send(con, NetUtils.urlEncode("rn", fileName, "rp", path), false);
        HTTPClient.Response res = this.checkResponseCode(con, GETFILE_OK_CODES);
        if (res.getCode() == 404) {
            fileConsumer.accept(null, null);
        } else if (res.getCode() == 200) {
            FileAttrs fileAttrs = new FileAttrs(path, fileName, Instant.ofEpochMilli(con.getLastModified()), -1L, con.getHeaderField("X-SHA256"));
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream in = this.getInputStream(con);){
                fileConsumer.accept(fileAttrs, in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return res;
    }

    public boolean saveFile(String path, String fileName, Path localFile) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        AtomicBoolean missing = new AtomicBoolean(true);
        HTTPClient.Response res = this.getFile(path, fileName, (fileAttrs, in) -> {
            missing.set(fileAttrs == null);
            if (!missing.get()) {
                fileAttrs.saveFile(in, localFile);
            }
        });
        if (!res.isSuccess()) {
            throw new IOException("Couldn't retrieve file " + fileName);
        }
        return !missing.get();
    }

    public HTTPClient.Response deleteFile(String path, String fileName) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        HttpsURLConnection con = this.openConnection("/delete");
        return this.checkResponseCode(this.send(con, NetUtils.urlEncode("rn", fileName, "rp", path), false));
    }

    public final HTTPClient.Response renameFile(String path, String fileName, String newFileName) throws IOException {
        return this.renameFile(path, fileName, null, newFileName);
    }

    public final HTTPClient.Response renameFile(String path, String fileName, String newPath, String newFileName) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        if (newPath == null) {
            throw new IllegalArgumentException("null newPath");
        }
        if (newFileName == null) {
            throw new IllegalArgumentException("null newFileName");
        }
        HttpsURLConnection con = this.openConnection("/rename");
        return this.checkResponseCode(this.send(con, NetUtils.urlEncode("rn", fileName, "rp", path, "newPath", newPath, "newName", newFileName), false));
    }

    public HTTPClient.Response sendFile(String path, File localFile) throws IOException {
        return this.sendFile(path, localFile, false);
    }

    public HTTPClient.Response sendFile(String path, File localFile, boolean overwrite) throws IOException {
        byte[] newsha256;
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        long size = localFile.length();
        if (size >= Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Required array size too large : " + size);
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream((int)size);
        Throwable throwable = null;
        Object var9_8 = null;
        try (BufferedInputStream ins = new BufferedInputStream(new FileInputStream(localFile));){
            newsha256 = MessageDigestUtils.getHash(MessageDigestUtils.getSHA256(), ins, ba);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        HttpsURLConnection con = this.openConnection("/put");
        con.setRequestProperty("X_FILENAME_B64", Base64.getEncoder().encodeToString(localFile.getName().getBytes(StandardCharsets.UTF_8)));
        con.setRequestProperty("X_PATH_B64", Base64.getEncoder().encodeToString(path.getBytes(StandardCharsets.UTF_8)));
        con.setRequestProperty("X-OVERWRITE", Boolean.toString(overwrite));
        con.setRequestProperty("X_FILESIZE", String.valueOf(size));
        con.setRequestProperty("X_SHA256", HashWriter.bytesToHex(newsha256));
        con.setRequestProperty("X-Last-Modified-ms", String.valueOf(localFile.lastModified()));
        return this.checkResponseCode(this.send(con, ba.toByteArray(), true));
    }

    protected static abstract class BaseAttrs {
        private final String path;
        private final String name;
        private final Instant lastModified;

        protected BaseAttrs(String path, String name, Instant lastModified) {
            this.path = path;
            this.name = name;
            this.lastModified = lastModified;
        }

        public final String getPath() {
            return this.path;
        }

        public final String getName() {
            return this.name;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " '" + this.getName() + "'";
        }
    }

    public static final class DirAttrs
    extends BaseAttrs {
        protected static DirAttrs fromJSON(String path, JSONArray array) {
            return new DirAttrs(path, (String)array.get(0), SimpleSyncClient.getInstant(array.get(1)));
        }

        protected DirAttrs(String path, String name, Instant lastModified) {
            super(path, name, lastModified);
        }
    }

    public static final class DirContent {
        private final String path;
        private final JSONObject json;

        protected DirContent(String path, JSONObject json) {
            this.path = path;
            this.json = json;
        }

        public final List<FileAttrs> getFiles() {
            return this.getFiles(null);
        }

        public final List<FileAttrs> getFiles(Predicate<String> namePredicate) {
            return this.getContent("files", namePredicate, FileAttrs::fromJSON);
        }

        public final List<DirAttrs> getDirs() {
            return this.getDirs(null);
        }

        public final List<DirAttrs> getDirs(Predicate<String> namePredicate) {
            return this.getContent("dirs", namePredicate, DirAttrs::fromJSON);
        }

        protected final <T extends BaseAttrs> List<T> getContent(String key, Predicate<String> namePredicate, BiFunction<String, JSONArray, T> create) {
            JSONArray files = (JSONArray)this.json.get(key);
            if (files == null) {
                return Collections.emptyList();
            }
            ArrayList<BaseAttrs> res = new ArrayList<BaseAttrs>();
            for (Object f : files) {
                JSONArray array = (JSONArray)f;
                if (namePredicate != null && !namePredicate.test((String)array.get(0))) continue;
                res.add((BaseAttrs)create.apply(this.path, array));
            }
            return res;
        }
    }

    public static final class FileAttrs
    extends BaseAttrs {
        private final long size;
        private final String sha256;

        protected static FileAttrs fromJSON(String path, JSONArray array) {
            return new FileAttrs(path, (String)array.get(0), SimpleSyncClient.getInstant(array.get(2)), SimpleSyncClient.getLong(array.get(1)), (String)array.get(3));
        }

        protected FileAttrs(String path, String name, Instant lastModified, long size, String sha256) {
            super(path, name, lastModified);
            this.size = size;
            this.sha256 = sha256;
        }

        public final long getSize() {
            return this.size;
        }

        public final String getSHA256() {
            return this.sha256;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void saveFile(InputStream in, Path localFile) throws IOException {
            Path tmpFile = Files.createTempFile(localFile.getParent(), "partial", null, new FileAttribute[0]);
            try {
                String savedHash;
                long savedSize;
                MessageDigest md;
                block18: {
                    md = this.getSHA256() == null ? null : MessageDigestUtils.getSHA256();
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try {
                        BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));
                        try {
                            try (FilterOutputStream out = md == null ? fileStream : new DigestOutputStream(fileStream, md);){
                                StreamUtils.copy(in, out);
                            }
                            if (fileStream == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (fileStream == null) throw throwable;
                            fileStream.close();
                            throw throwable;
                        }
                        fileStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                if (this.getSize() >= 0L && (savedSize = Files.size(tmpFile)) != this.getSize()) {
                    throw new IOException("Expected " + this.getSize() + " bytes but saved " + savedSize);
                }
                if (md != null && !(savedHash = MessageDigestUtils.getHashString(md)).equalsIgnoreCase(this.getSHA256())) {
                    throw new IOException("Expected hash was " + this.getSHA256() + " but saved " + savedHash);
                }
                Files.move(tmpFile, localFile, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                Files.deleteIfExists(tmpFile);
            }
            if (this.getLastModified().compareTo(Instant.EPOCH) <= 0) return;
            Files.setLastModifiedTime(localFile, FileTime.from(this.getLastModified()));
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " of size " + this.getSize();
        }
    }

    @FunctionalInterface
    public static interface FileConsumer {
        public void accept(FileAttrs var1, InputStream var2) throws IOException;
    }
}

