/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.jsonrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.openconcerto.utils.Base64;
import org.openconcerto.utils.NetUtils;

public class JSONRPCClient {
    private boolean trustAllContext;
    private String token;
    private String login;
    private String encodedPassword;

    public JSONRPCClient(boolean trustAllContext) {
        this.trustAllContext = trustAllContext;
    }

    public void setAuthToken(String token) {
        this.token = token;
    }

    public void setCredentials(String login, String encodedPassword) {
        this.login = login;
        this.encodedPassword = encodedPassword;
        System.err.println("JSONRPCClient.setCredentials()" + login + "/" + encodedPassword);
    }

    public JSONObject rpcCall(String url, String method, JSONObject params) throws IOException {
        JSONObject request = new JSONObject();
        request.put("jsonrpc", "2.0");
        request.put("method", method);
        request.put("id", UUID.randomUUID().toString());
        request.put("params", params);
        HttpsURLConnection con = (HttpsURLConnection)new URL(url).openConnection();
        con.setRequestProperty("Accept-Encoding", "gzip");
        con.setDoOutput(true);
        if (this.trustAllContext) {
            try {
                con.setSSLSocketFactory(NetUtils.createTrustAllContext().getSocketFactory());
                con.setHostnameVerifier(NetUtils.HostnameNonVerifier);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e1) {
                throw new IOException(e1);
            }
        }
        String str = request.toJSONString(JSONStyle.NO_COMPRESS);
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        System.err.println("JSONRPCClient.rpcCall()" + url + " : " + str);
        con.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        if (this.token != null) {
            con.setRequestProperty("Authorization", "Bearer " + this.token);
        } else {
            if (this.login != null) {
                con.setRequestProperty("X_LOGIN", Base64.encodeBytes(this.login.getBytes(StandardCharsets.UTF_8)));
            }
            if (this.encodedPassword != null) {
                con.setRequestProperty("X_PASSWORD_HASH", this.encodedPassword);
            }
        }
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (OutputStream out = con.getOutputStream();){
            out.write(bytes);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        JSONParser p = new JSONParser(-1);
        try {
            throwable2 = null;
            Object var10_15 = null;
            try (InputStream inputStream = "gzip".equals(con.getContentEncoding()) ? new GZIPInputStream(con.getInputStream()) : con.getInputStream();){
                JSONObject response = (JSONObject)p.parse(inputStream);
                if (response.containsKey("error")) {
                    JSONObject jsonObject = (JSONObject)response.get("error");
                    if (jsonObject.getAsNumber("code").intValue() == -32601) {
                        throw new IOException("method not found on server :" + method + " code : " + jsonObject.getAsNumber("code") + " : " + jsonObject.getAsString("message"));
                    }
                    throw new IOException("rpc call error, code : " + jsonObject.getAsNumber("code") + " : " + jsonObject.getAsString("message"));
                }
                return (JSONObject)response.get("result");
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }
}

