/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public abstract class ZippedFilesProcessor {
    public void process(InputStream input) throws IOException {
        JarEntry entry;
        JarInputStreamWrapper in = new JarInputStreamWrapper(input);
        while ((entry = in.getNextJarEntry()) != null) {
            this.processEntry(entry, in);
            in.closeEntry();
        }
        in.closeForReal();
    }

    protected abstract void processEntry(ZipEntry var1, InputStream var2) throws IOException;

    private static class JarInputStreamWrapper
    extends JarInputStream {
        public JarInputStreamWrapper(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public void close() {
        }

        public void closeForReal() throws IOException {
            super.close();
        }
    }
}

