/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.LightUserControl;
import org.openconcerto.utils.io.JSONConverter;

public class LightUISlider
extends LightUserControl
implements Externalizable {
    private int minValue = 0;
    private int maxValue = 1;
    private int increment = 1;
    private Map<Integer, String> mapLabels = new HashMap<Integer, String>();

    public LightUISlider() {
    }

    public LightUISlider(String id) {
        super(id);
        this.setType(18);
        this.setValueType(1);
        this.setValue("0");
    }

    public LightUISlider(JSONObject json) {
        super(json);
    }

    public LightUISlider(LightUISlider slider) {
        super(slider);
        this.maxValue = slider.maxValue;
        this.minValue = slider.minValue;
        this.increment = slider.increment;
    }

    public void setLabel(int value, String label) {
        this.mapLabels.put(value, label);
    }

    public String getLabelForValue(int value) {
        return this.mapLabels.get(value);
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        if (maxValue < this.minValue) {
            throw new IllegalArgumentException("max cannot be < " + this.minValue);
        }
        this.maxValue = maxValue;
        if (this.getMinWidth() == null) {
            this.setMinWidth((this.maxValue - this.minValue) * 50);
        }
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        if (minValue > this.maxValue) {
            throw new IllegalArgumentException("min cannot be > " + this.maxValue);
        }
        this.minValue = minValue;
        if (this.getMinWidth() == null) {
            this.setMinWidth((this.maxValue - this.minValue) * 50);
        }
    }

    public Integer getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public void setSelectedValue(int value) {
        this.setValue(String.valueOf(value));
    }

    public int getSelectedValue() {
        return Integer.parseInt(this.getValue());
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("max-value", this.maxValue);
        json.put("min-value", this.minValue);
        json.put("increment", this.increment);
        if (!this.mapLabels.isEmpty()) {
            JSONObject labels = new JSONObject();
            for (Map.Entry<Integer, String> entry : this.mapLabels.entrySet()) {
                Integer key = entry.getKey();
                String value = entry.getValue();
                labels.put(String.valueOf(key), value);
            }
            json.put("labels", labels);
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.maxValue = JSONConverter.getParameterFromJSON(json, "max-value", Integer.class, 1);
        this.minValue = JSONConverter.getParameterFromJSON(json, "min-value", Integer.class, 0);
        this.increment = JSONConverter.getParameterFromJSON(json, "increment", Integer.class, 1);
        this.mapLabels.clear();
        if (json.containsKey("labels")) {
            JSONObject labels = (JSONObject)json.get("labels");
            for (String key : labels.keySet()) {
                String v = labels.getAsString(key);
                this.mapLabels.put(Integer.parseInt(key), v);
            }
        }
    }

    @Override
    public void _setValueFromContext(Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Incorrect value " + value + "type for ui element: " + this.getId());
        }
        this.setValue(value.toString());
    }

    @Override
    public Object getValueForContext() {
        if (this.getValue() == null) {
            return null;
        }
        return Integer.parseInt(this.getValue());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.minValue);
        out.writeInt(this.maxValue);
        out.writeInt(this.increment);
        out.writeInt(this.mapLabels.size());
        for (Map.Entry<Integer, String> entry : this.mapLabels.entrySet()) {
            out.writeInt(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.minValue = in.readInt();
        this.maxValue = in.readInt();
        this.increment = in.readInt();
        this.mapLabels.clear();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.mapLabels.put(in.readInt(), in.readUTF());
            ++i;
        }
    }
}

