/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.sales.invoice.report.ListeVenteXmlSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;

public class GenListeVentePanel
extends JPanel
implements ActionListener {
    private final JButton buttonGen = new JButton("Cr\u00e9er");
    private final JDate du;
    private final JDate au;
    JProgressBar bar = new JProgressBar();

    public GenListeVentePanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 10;
        this.add((Component)new JLabelBold("Journal des Ventes"), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.anchor = 17;
        this.add((Component)new JLabel("Du"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.du = new JDate(true);
        this.add((Component)this.du, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.au = new JDate(true);
        this.add((Component)this.au, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.add((Component)this.bar, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        JPanel panelButton = new JPanel();
        panelButton.add(this.buttonGen);
        JButton buttonClose = new JButton("Fermer");
        panelButton.add(buttonClose);
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 14;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.add((Component)panelButton, c);
        this.buttonGen.addActionListener(this);
        buttonClose.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonGen) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLTable tableFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE").getTable();
                        SQLTable tableAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT").getTable();
                        SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
                        SQLDataSource dataSource = Configuration.getInstance().getBase().getDataSource();
                        sel.addSelectStar(tableFact);
                        sel.setDistinct(true);
                        sel.setWhere(new Where((FieldRef)tableFact.getField("DATE"), GenListeVentePanel.this.du.getDate(), (Object)GenListeVentePanel.this.au.getDate()));
                        ArrayList l = new ArrayList((List)dataSource.execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, tableFact)));
                        Collections.sort(l, new Comparator<SQLRow>(){

                            @Override
                            public int compare(SQLRow o1, SQLRow o2) {
                                int dateComp = o1.getDate("DATE").compareTo(o2.getDate("DATE"));
                                if (dateComp == 0) {
                                    return o1.getString("NUMERO").compareTo(o2.getString("NUMERO"));
                                }
                                return dateComp;
                            }
                        });
                        SQLSelect sel2 = new SQLSelect(Configuration.getInstance().getBase());
                        sel2.addSelectStar(tableAvoir);
                        sel2.setWhere(new Where((FieldRef)tableAvoir.getField("DATE"), GenListeVentePanel.this.du.getDate(), (Object)GenListeVentePanel.this.au.getDate()));
                        sel2.setDistinct(true);
                        ArrayList l2 = new ArrayList((List)dataSource.execute(sel2.asString(), SQLRowListRSH.createFromSelect(sel2, tableAvoir)));
                        Collections.sort(l2, new Comparator<SQLRow>(){

                            @Override
                            public int compare(SQLRow o1, SQLRow o2) {
                                int dateComp = o1.getDate("DATE").compareTo(o2.getDate("DATE"));
                                if (dateComp == 0) {
                                    return o1.getString("NUMERO").compareTo(o2.getString("NUMERO"));
                                }
                                return dateComp;
                            }
                        });
                        ArrayList<SQLRow> lTotal = new ArrayList<SQLRow>();
                        lTotal.addAll(l);
                        lTotal.addAll(l2);
                        ListeVenteXmlSheet sheet = new ListeVenteXmlSheet(lTotal, GenListeVentePanel.this.du.getDate(), GenListeVentePanel.this.au.getDate(), GenListeVentePanel.this.bar);
                        sheet.createDocumentAsynchronous().get();
                        sheet.showPrintAndExport(true, false, false);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur de traitement", e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JFrame)SwingUtilities.getRoot(GenListeVentePanel.this)).dispose();
                        }
                    });
                }
            });
            thread.start();
        } else {
            ((JFrame)SwingUtilities.getRoot(this)).dispose();
        }
    }
}

