/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.generationDoc.A4;
import org.openconcerto.erp.generationDoc.ProgressPrintingFrame;
import org.openconcerto.erp.generationDoc.gestcomm.FicheRelanceSheet;
import org.openconcerto.erp.generationDoc.gestcomm.RelanceSheet;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.ExceptionHandler;

public class RelanceSQLElement
extends ComptaSQLConfElement {
    public static final String ITEM_TYPE = "type.id";
    public static final String ITEM_DATE = "date";
    public static final String ITEM_NUMBER = "number";
    public static final String ITEM_CUSTOMER = "customer.id";
    public static final String ITEM_SALES_INVOICE_INPUT = "sales.invoice.input.id";
    public static final String ITEM_AMOUNT = "amount";
    public static final String ITEM_INFORMATIONS = "informations";
    public static final String ITEM_VISUALIZATION = "visualization";
    public static final String ITEM_PRINT = "impression";
    private static final double POINTS_PER_INCH = 72.0;

    public RelanceSQLElement() {
        super("RELANCE", "une relance client", "relances clients");
        RowAction actionShowDoc = new RowAction(new AbstractAction("Voir le document"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelanceSheet s = new RelanceSheet(IListe.get(e).getSelectedRow().asRow().fetchNew(false));
                s.generate(false, false, "");
                s.showDocument();
            }
        }, false){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.size() == 1) {
                    SQLRowValues rowRelance = selection.get(0);
                    boolean isNotMail = rowRelance.getForeign("ID_TYPE_LETTRE_RELANCE") != null && !rowRelance.isForeignEmpty("ID_TYPE_LETTRE_RELANCE");
                    return isNotMail;
                }
                return false;
            }
        };
        this.getRowActions().add(actionShowDoc);
        RowAction actionPrintDoc = new RowAction(new AbstractAction("Imprimer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelanceSQLElement.this.print(e, false);
            }
        }, false){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.size() >= 1) {
                    boolean isNotMail = true;
                    for (SQLRowValues rowRelance : selection) {
                        isNotMail &= rowRelance.getForeign("ID_TYPE_LETTRE_RELANCE") != null && !rowRelance.isForeignEmpty("ID_TYPE_LETTRE_RELANCE");
                    }
                    return isNotMail;
                }
                return false;
            }
        };
        this.getRowActions().add(actionPrintDoc);
        RowAction actionPrintDocFact = new RowAction(new AbstractAction("Imprimer avec la facture"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelanceSQLElement.this.print(e, true);
            }
        }, false){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.size() >= 1) {
                    boolean isNotMail = true;
                    for (SQLRowValues rowRelance : selection) {
                        isNotMail &= rowRelance.getForeign("ID_TYPE_LETTRE_RELANCE") != null && !rowRelance.isForeignEmpty("ID_TYPE_LETTRE_RELANCE");
                    }
                    return isNotMail;
                }
                return false;
            }
        };
        this.getRowActions().add(actionPrintDocFact);
        RowAction actionGen = new RowAction(new AbstractAction("G\u00e9n\u00e9rer le document"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (SQLRowValues rowVals : IListe.get(e).getSelectedRows()) {
                    RelanceSheet s = new RelanceSheet(rowVals.asRow().fetchNew(false));
                    String printer = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
                    s.generate(false, true, printer, true);
                    s.showDocument();
                }
            }
        }, false){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection.size() >= 1) {
                    SQLRowValues rowRelance = selection.get(0);
                    boolean isNotMail = rowRelance.getForeign("ID_TYPE_LETTRE_RELANCE") != null && !rowRelance.isForeignEmpty("ID_TYPE_LETTRE_RELANCE");
                    return isNotMail;
                }
                return false;
            }
        };
        this.getRowActions().add(actionGen);
        RowAction actionFiche = new RowAction(new AbstractAction("Cr\u00e9er la fiche de relance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FicheRelanceSheet sheet = new FicheRelanceSheet(IListe.get(e).getSelectedRow().asRow().fetchNew(false));
                    sheet.createDocumentAsynchronous();
                    sheet.showPrintAndExportAsynchronous(true, false, true);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Impression impossible", ex);
                }
            }
        }, false){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection.size() == 1;
            }
        };
        this.getRowActions().add(actionFiche);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("ID_CLIENT");
        l.add("ID_SAISIE_VENTE_FACTURE");
        l.add("DATE");
        l.add("ID_TYPE_LETTRE_RELANCE");
        l.add("MONTANT");
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            ElementComboBox comboFacture;
            ElementComboBox comboClient;
            ElementComboBox comboTypeLettre;
            JUniqueTextField textNumero;
            JCheckBox checkImpression;
            JCheckBox checkVisu;
            {
                this.comboFacture = new ElementComboBox();
                this.comboClient = new ElementComboBox();
                this.textNumero = new JUniqueTextField();
                this.checkImpression = new JCheckBox("Impression");
                this.checkVisu = new JCheckBox("Visualisation");
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelTypeLettre = new JLabel(this.getLabelFor("ID_TYPE_LETTRE_RELANCE"));
                labelTypeLettre.setHorizontalAlignment(4);
                this.add((Component)labelTypeLettre, c);
                ++c.gridx;
                this.comboTypeLettre = new ElementComboBox(false);
                this.add((Component)this.comboTypeLettre, c);
                ++c.gridx;
                JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
                labelDate.setHorizontalAlignment(4);
                this.add((Component)labelDate, c);
                JDate date = new JDate(true);
                ++c.gridx;
                this.add((Component)date, c);
                c.gridx = 0;
                ++c.gridy;
                JLabel labelNumero = new JLabel(this.getLabelFor("NUMERO"));
                labelNumero.setHorizontalAlignment(4);
                this.add((Component)labelNumero, c);
                ++c.gridx;
                this.add((Component)this.textNumero, c);
                ++c.gridy;
                c.gridx = 0;
                JLabel labelClient = new JLabel(this.getLabelFor("ID_CLIENT"));
                labelClient.setHorizontalAlignment(4);
                this.add((Component)labelClient, c);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)this.comboClient, c);
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                JLabel labelFacture = new JLabel(this.getLabelFor("ID_SAISIE_VENTE_FACTURE"));
                labelFacture.setHorizontalAlignment(4);
                this.add((Component)labelFacture, c);
                ++c.gridx;
                this.add((Component)this.comboFacture, c);
                ++c.gridx;
                JLabel labelMontant = new JLabel(this.getLabelFor("MONTANT"));
                labelMontant.setHorizontalAlignment(4);
                this.add((Component)labelMontant, c);
                ++c.gridx;
                DeviseField textMontant = new DeviseField();
                this.add((Component)textMontant, c);
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)new JLabel(this.getLabelFor("INFOS")), c);
                ++c.gridx;
                c.gridwidth = 0;
                c.fill = 2;
                c.weightx = 1.0;
                this.add((Component)new JSeparator(0), c);
                c.gridx = 0;
                ++c.gridy;
                c.weighty = 1.0;
                c.fill = 1;
                ITextArea textInfos = new ITextArea();
                this.add((Component)textInfos, c);
                JPanel panelCheck = new JPanel();
                panelCheck.setBorder(null);
                panelCheck.add(this.checkVisu);
                panelCheck.add(this.checkImpression);
                c.fill = 0;
                c.weighty = 0.0;
                ++c.gridy;
                this.add((Component)panelCheck, c);
                this.addRequiredSQLObject(textMontant, "MONTANT");
                this.addRequiredSQLObject(date, "DATE");
                this.addRequiredSQLObject(this.comboTypeLettre, "ID_TYPE_LETTRE_RELANCE");
                this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
                this.addRequiredSQLObject(this.comboFacture, "ID_SAISIE_VENTE_FACTURE");
                this.addSQLObject(textInfos, "INFOS");
                this.addRequiredSQLObject(this.textNumero, "NUMERO");
                this.comboTypeLettre.setButtonsVisible(false);
                this.textNumero.setText(NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class));
                this.checkVisu.setSelected(true);
            }

            @Override
            public int insert(SQLRow order) {
                if (this.textNumero.checkValidation()) {
                    if (NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class).equalsIgnoreCase(this.textNumero.getText().trim())) {
                        SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
                        SQLRowValues rowVals = new SQLRowValues(tableNum);
                        int val = tableNum.getRow(2).getInt("RELANCE_START");
                        rowVals.put("RELANCE_START", (Object)(++val));
                        try {
                            rowVals.update(2);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    int id = super.insert(order);
                    RelanceSheet s = new RelanceSheet(this.getTable().getRow(id));
                    String printer = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
                    s.generate(this.checkImpression.isSelected(), this.checkVisu.isSelected(), printer, true);
                    return id;
                }
                ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de relance existant.");
                Component root = SwingUtilities.getRoot(this);
                if (root instanceof EditFrame) {
                    EditFrame frame = (EditFrame)root;
                    frame.getPanel().setAlwaysVisible(true);
                }
                return this.getSelectedID();
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                this.comboFacture.setInteractionMode(InteractionMode.DISABLED);
                this.comboClient.setInteractionMode(InteractionMode.DISABLED);
                this.fireValidChange();
            }

            @Override
            public void update() {
                if (!this.textNumero.checkValidation()) {
                    ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de relance existant.");
                    Component root = SwingUtilities.getRoot(this);
                    if (root instanceof EditFrame) {
                        EditFrame frame = (EditFrame)root;
                        frame.getPanel().setAlwaysVisible(true);
                    }
                    return;
                }
                super.update();
                RelanceSheet s = new RelanceSheet(this.getTable().getRow(this.getSelectedID()));
                String printer = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
                s.generate(this.checkImpression.isSelected(), this.checkVisu.isSelected(), printer);
            }
        };
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            if (row.getForeign("ID_ECHEANCE_CLIENT") == null || row.isForeignEmpty("ID_ECHEANCE_CLIENT")) continue;
            SQLRow rowEch = row.getForeign("ID_ECHEANCE_CLIENT");
            int count = rowEch.getInt("NOMBRE_RELANCE");
            count = Math.max(0, count - 1);
            SQLRowValues rowValsUp = rowEch.createEmptyUpdateRow();
            rowValsUp.put("NOMBRE_RELANCE", count);
            rowValsUp.put("DATE_LAST_RELANCE", null);
            if (count > 0) {
                Collection rows = rowEch.getReferentRows(row.getTable());
                Calendar cal = null;
                for (SQLRow sqlRow : rows) {
                    if (sqlRow.getID() == row.getID() || sqlRow.getDate("DATE") == null || cal != null && !cal.before(sqlRow.getDate("DATE"))) continue;
                    cal = sqlRow.getDate("DATE");
                }
                if (cal != null) {
                    rowValsUp.put("DATE_LAST_RELANCE", cal.getTime());
                }
            }
            rowValsUp.commit();
        }
        super.archive(trees, cutLinks);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".chaseletter";
    }

    public void print(ActionEvent ev, final boolean withInvoice) {
        IListe ilist = IListe.get(ev);
        String printerName = PrinterNXProps.getInstance().getStringProperty("RelancePrinter");
        final PrinterJob printJob = PrinterJob.getPrinterJob();
        PrintService myService = null;
        if (printerName != null && printerName.trim().length() > 0) {
            PrintService[] services = PrinterJob.lookupPrintServices();
            int i = 0;
            while (i < services.length) {
                if (services[i].getName().equals(printerName)) {
                    myService = services[i];
                    break;
                }
                ++i;
            }
            if (myService != null) {
                try {
                    printJob.setPrintService(myService);
                }
                catch (PrinterException e) {
                    Log.get().log(Level.SEVERE, "cannot print", e);
                    JOptionPane.showMessageDialog(null, "Imprimante non compatible");
                    return;
                }
            }
        }
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        MediaSizeName media = MediaSizeName.ISO_A4;
        attributes.add(media);
        A4 paper = new A4(0.0f, 0.0f);
        MediaPrintableArea printableArea = new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400);
        attributes.add(printableArea);
        attributes.add(new Copies(1));
        boolean okToPrint = printJob.printDialog(attributes);
        Attribute attribute = attributes.get(Copies.class);
        if (attribute != null) {
            Copies attributeCopies = (Copies)attribute;
            int value = attributeCopies.getValue();
            printJob.setCopies(value);
        } else {
            printJob.setCopies(1);
        }
        if (okToPrint) {
            Window w = SwingUtilities.getWindowAncestor(ilist);
            final ProgressPrintingFrame pFrame = new ProgressPrintingFrame(w, printJob, "Impression", "Impression en cours", 300);
            final List<SQLRowValues> rows = IListe.get(ev).getSelectedRows();
            Thread thread = new Thread(){

                @Override
                public void run() {
                    final int size = rows.size();
                    int i = 0;
                    while (i < size) {
                        final int index = i;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                pFrame.setMessage("Document " + (index + 1) + "/" + size);
                                pFrame.setProgress(100 * (index + 1) / size);
                            }
                        });
                        if (!pFrame.isCancelled()) {
                            SQLRowValues r = (SQLRowValues)rows.get(i);
                            SQLRow rowRelance = r.asRow().fetchNew(false);
                            RelanceSheet s = new RelanceSheet(rowRelance);
                            s.printDocument(printJob);
                            if (withInvoice) {
                                SaisieVenteFactureSQLElement element = RelanceSQLElement.this.getDirectory().getElement(SaisieVenteFactureSQLElement.class);
                                VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowRelance.getForeignRow("ID_SAISIE_VENTE_FACTURE"));
                                try {
                                    sheet.getOrCreateDocumentFile();
                                    sheet.printDocument(printJob);
                                }
                                catch (Exception e) {
                                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation de la facture", e);
                                }
                            }
                        }
                        ++i;
                    }
                }
            };
            thread.setPriority(1);
            thread.setDaemon(true);
            pFrame.setLocationRelativeTo(ilist);
            pFrame.setVisible(true);
            thread.start();
        }
    }
}

