/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int REHASH_GROWTH = 2;
    private static final int MIN_CAPACITY = 4;
    private static final int SIZE_THRESHOLD = 6;
    private int maxSize;

    public LRUMap(int maxSize) {
        this(maxSize, maxSize <= 6 ? 4 : (int)((float)maxSize / 0.75f / 2.0f + 1.0f));
    }

    public LRUMap(int maxSize, int initialCapacity) {
        this(maxSize, initialCapacity, 0.75f);
    }

    public LRUMap(int maxSize, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.setMaxSize(maxSize);
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    protected final boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.getMaxSize();
    }
}

