/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;

abstract class BaseSQLElementRow {
    private final SQLElement elem;
    private final SQLRow row;

    private static final SQLElement getElementStatic(SQLRow r) {
        return Configuration.getInstance().getDirectory().getElement(r.getTable());
    }

    public BaseSQLElementRow(SQLRow row) {
        this(BaseSQLElementRow.getElementStatic(row), row);
    }

    public BaseSQLElementRow(SQLElement element, SQLRow row) {
        if (!row.getTable().equals(element.getTable())) {
            throw new IllegalArgumentException(row.getTable() + " != " + element.getTable());
        }
        this.elem = element;
        this.row = row;
    }

    public int hashCode() {
        return this.row.getTable().hashCode();
    }

    public abstract boolean equals(Object var1);

    public String toString() {
        return this.row + " (" + this.elem + ")";
    }

    protected final SQLElement getElem() {
        return this.elem;
    }

    protected final SQLRow getRow() {
        return this.row;
    }

    protected final SQLElement getElement(SQLRow r) {
        return BaseSQLElementRow.getElementStatic(r);
    }
}

