/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

public abstract class OSFamily {
    public static final Unix Mac = new Unix();
    public static final Unix Linux = new Unix();
    public static final Unix FreeBSD = new Unix();
    public static final OSFamily Windows = new OSFamily(){};
    private static final OSFamily INSTANCE = OSFamily.getCurrentOS();

    private static final OSFamily getCurrentOS() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return Windows;
        }
        if (os.startsWith("Mac OS")) {
            return Mac;
        }
        if (os.startsWith("Linux")) {
            return Linux;
        }
        if (os.startsWith("FreeBSD")) {
            return FreeBSD;
        }
        System.err.println("Unsupported OS " + os);
        return null;
    }

    public static final OSFamily getInstance() {
        return INSTANCE;
    }

    public static class Unix
    extends OSFamily {
    }
}

